package ru.scancode.GodexPrintTest;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.util.Log;

import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.ext.junit.runners.AndroidJUnit4;

import org.junit.Test;
import org.junit.runner.RunWith;

import java.nio.ByteBuffer;

import static org.junit.Assert.*;

/**
 * Instrumented test, which will execute on an Android device.
 *
 * @see <a href="http://d.android.com/tools/testing">Testing documentation</a>
 */
@RunWith(AndroidJUnit4.class)
public class ExampleInstrumentedTest {
    @Test
    public void useAppContext() throws Exception {
        // Context of the app under test.
        Context appContext = InstrumentationRegistry.getInstrumentation().getContext();

        assertEquals("ru.scancode.testmobileprint", appContext.getPackageName());
    }


    @Test
    public void bitTests() throws Exception {
        //             1                 2                 3
        int[] array = {1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Log.i("TAG", "array.length = " + array.length);
        byte workByte = 0;
        boolean fullByte = false;
        int bitCounter = 0;
        ByteBuffer buffer = ByteBuffer.allocate(3);

        for (int i = 0; i < array.length; i++) {
            if (array[i] == 1) workByte++;

            bitCounter++;
            if (bitCounter == 8) fullByte = true;
            if (fullByte) {
                Log.i("TAG", "workByte = " + workByte);
                buffer.put(workByte);
                workByte = 0;
                fullByte = false;
                bitCounter = 0;
            } else {
                workByte = (byte) (workByte << 1);
            }
        }

        workByte = (byte) (workByte << (3 - 1));
        Log.i("TAG", "workByte = " + workByte);
        buffer.put(workByte);

        assertEquals(1, 1);
    }

    @Test
    public void colorTests() throws Exception {

//        FF629DA5
        int color = 0xFF629DA5;

        int blue = Color.blue(color);
        int red = Color.red(color);
        int green = Color.green(color);
        int alpha = Color.alpha(color);

        assertEquals(1, 1);
    }

}




