package ru.scancode.GodexPrintTest;

import android.os.Bundle;
import android.os.Parcel;
import android.util.SparseArray;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;

import ru.scancode.GodexPrintTest.dialogs.VariablePromptDialog;

public abstract class AbstractPage extends Fragment {
    public static final String ARG_TITLE="title";
    protected static final String xml_header="<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String EXTRA_VARIABLE ="vars";
    public static final String EXTRA_QUANTITY ="count";
    public static final int REQUEST_ANSWER_CODE=0;

    protected FragmentActivity m_parentActivity;
    protected boolean bPromptDialogIsShown=false;

    //для запроса значений переменных в cmd или сохраненном шаблоне при печати
    protected SparseArray<variable> variables= new SparseArray<>();
    protected DataPacker.InnerParam param;
    protected DataPacker packer;
    protected VariablePromptDialog dlg;
    protected static String m_quantity="1";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        m_parentActivity =getActivity();
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    public String getTitle(){
        String title="";
        Bundle args=getArguments();

        if(args!=null) {
            title=args.getString(ARG_TITLE);
        }
        return title;
    }

    public void setQuantity(int nQuantity){
        m_quantity=String.valueOf(nQuantity);
    }

    public abstract String getPrintData();
    public abstract SparseArray<variable> getVariables();
    public abstract void PromptVariables(SparseArray<variable> vars);

    public static class variable implements android.os.Parcelable{

        public variable() {
        }

        public variable(String value, String prompt, int nLen) {
            this.value = value;
            this.nLen = nLen;
            this.prompt=prompt;
        }

        public String value;
        public String prompt;
        public int nLen;

        protected variable(Parcel in) {
            value = in.readString();
            prompt = in.readString();
            nLen = in.readInt();
        }

        public static final Creator<variable> CREATOR = new Creator<variable>() {
            @Override
            public variable createFromParcel(Parcel in) {
                return new variable(in);
            }

            @Override
            public variable[] newArray(int size) {
                return new variable[size];
            }
        };

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeValue(this);
        }
    }

    public static class template_label{
        public String m_name;
        private SparseArray<variable> m_vars= new SparseArray<>();

        public template_label() {
        }

        public template_label(String name) {
            this.m_name = name;
        }

        public template_label(String name, SparseArray<variable> vars) {
            this.m_name = name;
            m_vars=vars;
        }

        public void addVariable(variable var){
            m_vars.put(m_vars.size(), var);
        }

        public boolean isHasVariables(){
            return m_vars.size()>0;
        }

        public SparseArray<variable> getVariables(){
            return m_vars;
        }
    }
}
