package ru.scancode.GodexPrintTest;

import android.util.SparseArray;
import android.util.Xml;

import androidx.annotation.Nullable;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

//Класс упаковщик/парсер данных для службы печати

public class DataPacker implements Serializable {

    public static final String PRINT_ACTION ="mobile_print_action";
    public static final String EXTRA_DATA="data";
    public static final String EXTRA_ANSWER="answer";
    public static final String EXTRA_RESPONSE="response";
    public enum resp{
        RESP_OK,
        RESP_FAIL
    }

    //Поддерживаемые команды
    public enum commands{
        CMD_NONE,
        CMD_PRINT,
        CMD_CONNECT,
        CMD_GET_SAVED_TEMPLATES,
        CMD_PRINT_TEMPLATE,
        CMD_SEND_CMD,
        CMD_GET_PRINTER_STATUS,
        CMD_GET_SERIAL_USB,
        CMD_RESPONSE,
        CMD_LOAD_IMG_TO_PRINTER,
        CMD_DELETE_IMAGE,
        CMD_COUNT
    }

    //Типы параметров комад
    public enum parameters {
        PARAM_NONE,
        PARAM_TEMPLATE,
        PARAM_CMD_FILE,
        PARAM_CMD,
        PARAM_QUANTITY,
        PARAM_NUM_CUT,
        PARAM_TEMPLATE_VARS,
        PARAM_DATA,
        PARAM_RESULT,
        PARAM_IMG,
        PARAM_COUNT
    }

    //Типы значений параметров
    public enum values{
        VAL_NONE,
        VAL_PATH,
        VAL_TEMPLATE_NAME,
        VAL_DATA,
        VAL_VARIABLE,
        VAL_ERROR,

        VAL_COUNT
    }

    public static enum error_codes{
        ERR_NONE,
        ERR_NO_VARS
    }
    
    //private HashMap<parameters, InnerParam> params= new HashMap<>();
    private List<InnerParam> params= new ArrayList<>();

    private HashMap<parameters, String> map_param_names = new HashMap<>();
    private HashMap<commands, String> map_cmd_names = new HashMap<>();
    private HashMap<values, String> map_value_type_names =new HashMap<>();
    private InnerCommand cmd;

    //Поддерживаемые тэги в протоколе обмена данными со службой печати
    private final String COMMAND="cmd";
    private final String NAME="name";
    private final String LENGTH="length";
    private final String TYPE="type";
    private final String PARAM ="parameter";
    private final String PARAMS ="parameters";
    private final String VALUE="value";
    private final String ERROR_CODE="errCode";

    public DataPacker(){
        init();
    }

    public DataPacker(String data) throws XmlPullParserException, IOException {
        init();
        if(data!=null && !data.isEmpty()) {
            parse(data);
        }
    }

    private void init() {
        map_param_names.put(parameters.PARAM_TEMPLATE,        "template");
        map_param_names.put(parameters.PARAM_CMD_FILE,        "cmd_file");
        map_param_names.put(parameters.PARAM_CMD,             "cmd");
        map_param_names.put(parameters.PARAM_TEMPLATE_VARS,   "vars");
        map_param_names.put(parameters.PARAM_DATA,            "data");
        map_param_names.put(parameters.PARAM_RESULT,          "result");
        map_param_names.put(parameters.PARAM_QUANTITY,        "quantity");
        map_param_names.put(parameters.PARAM_IMG,             "image");

        map_cmd_names.put(commands.CMD_CONNECT,               "connect");
        map_cmd_names.put(commands.CMD_GET_SAVED_TEMPLATES,   "get_memory_state");
        map_cmd_names.put(commands.CMD_GET_PRINTER_STATUS,    "get_printer_status");
        map_cmd_names.put(commands.CMD_GET_SERIAL_USB,        "get_usb_serial");
        map_cmd_names.put(commands.CMD_NONE,                  "none");
        map_cmd_names.put(commands.CMD_PRINT,                 "print");
        map_cmd_names.put(commands.CMD_SEND_CMD,              "custom_command");
        map_cmd_names.put(commands.CMD_RESPONSE,              "response");
        map_cmd_names.put(commands.CMD_LOAD_IMG_TO_PRINTER,   "load_img_to_printer");
        map_cmd_names.put(commands.CMD_DELETE_IMAGE,          "delete_image");

        map_value_type_names.put(values.VAL_COUNT,            "count");
        map_value_type_names.put(values.VAL_DATA,             "data");
        map_value_type_names.put(values.VAL_PATH,             "path");
        map_value_type_names.put(values.VAL_TEMPLATE_NAME,    "template");
        map_value_type_names.put(values.VAL_VARIABLE,         "variable");
        map_value_type_names.put(values.VAL_ERROR,            "error");
    }

    private commands getCmdType(String name){
        commands result=commands.CMD_NONE;

        Set<commands> keys=map_cmd_names.keySet();
        Iterator<commands> it=keys.iterator();
        while(it.hasNext()){
            commands key=it.next();
            if(map_cmd_names.get(key).equals(name)){
                result=key;
                break;
            }
        }
        return result;
    }

    private values getValueType(String name){
        values result=values.VAL_NONE;

        Set<values> keys= map_value_type_names.keySet();
        Iterator<values> it=keys.iterator();
        while(it.hasNext()){
            values key=it.next();
            if(map_value_type_names.get(key).equals(name)){
                result=key;
                break;
            }
        }
        return result;
    }

    private parameters getParamType(String name){
        parameters result=parameters.PARAM_NONE;

        Set<parameters> keys=map_param_names.keySet();
        Iterator<parameters> it=keys.iterator();
        while(it.hasNext()){
            parameters key=it.next();
            if(map_param_names.get(key).equals(name)){
                result=key;
                break;
            }
        }
        return result;
    }

    private error_codes getErrCodeByOrdinal(int nOrdinal){
        error_codes result=error_codes.ERR_NONE;
        error_codes[] errors=error_codes.values();
        for(int i=0; i<errors.length; i++){
            if(nOrdinal==i){
                result=errors[i];
                break;
            }
        }
        return result;
    }

    private void parse(String data){
        if(data==null || data.isEmpty())
            return;

        StringReader reader= new StringReader(data);
        XmlPullParser m_parser= Xml.newPullParser();
        try {
            m_parser.setInput(reader);
            InnerParam param=null;

            int eventType=m_parser.getEventType();
            while(eventType!=XmlPullParser.END_DOCUMENT){

                switch(eventType){
                    case XmlPullParser.START_TAG:
                        String tagName=m_parser.getName();
                        if(tagName.equals(COMMAND)){
                            String name=m_parser.getAttributeValue("",NAME);
                            cmd=new InnerCommand(getCmdType(name));
                        }
                        else if(tagName.equals(PARAM)){
                            String name=m_parser.getAttributeValue("",NAME);
                            String type=m_parser.getAttributeValue("",TYPE);
                            parameters pType=getParamType(type);
                            param=new InnerParam(pType, name);
                            params.add(param);
                        }
                        else if(tagName.equals(VALUE)){
                            values val_type=values.VAL_NONE;
                            String val_name="";
                            String val_value="";
                            int nLen=0;
                            error_codes err=error_codes.ERR_NONE;

                            for(int i=0; i<m_parser.getAttributeCount(); i++){
                                String name=m_parser.getAttributeName(i);
                                String value=m_parser.getAttributeValue(i);

                                if(name.equals(TYPE)) {
                                    val_type=getValueType(value);
                                }
                                else if(name.equals(NAME)){
                                    val_name=value;
                                }
                                else if(name.equals(LENGTH)){
                                    try {
                                        nLen = Integer.parseInt(value);
                                    }
                                    catch(NumberFormatException e){
                                        utils.logger.get().write("не верно указана длина переменной");
                                    }
                                }
                                else if(name.equals(ERROR_CODE)){
                                    err=getErrCodeByOrdinal(Integer.parseInt(value));
                                }
                                else if(name.equals(VALUE)){
                                    val_value=value;
                                }
                            }
                            if(param!=null) {
                                InnerParam.value val = param.addValue(val_type, val_name, val_value, nLen);
                                val.setErrCode(err);
                            }
                        }
                        break;
                    default:
                        break;
                }

                eventType=m_parser.next();
            }
        } catch (Exception e) {
            utils.logger.get().write(e.getMessage());
        }
    }

    public InnerParam addParam(parameters p, values vType, String name, String value){
        InnerParam result=new InnerParam(p);
        if(value!=null && !value.isEmpty()) {
            result.addValue(vType, name, value);
        }
        params.add(result);

        return result;
    }

    public InnerParam addParam(parameters p, String name){
        InnerParam result=new InnerParam(p, name);
        params.add(result);

        return result;
    }

    public void setCommand(commands cmd) throws IllegalStateException{
        this.cmd =new InnerCommand(cmd);
    }

    public InnerCommand getCommand(){
        return cmd;
    }

//    @Nullable
//    public InnerParam getParam(parameters p){
//        return params.get(p);
//    }

    public List<InnerParam> getParams(){
        return params;
    }

    @Nullable
    public InnerParam getResult(){
        InnerParam result=null;
        for(InnerParam param: params){
            if(param.getType().equals(parameters.PARAM_RESULT)){
                result=param;
                break;
            }
        }
        return result;
    }

    @Nullable
    public InnerParam getQuantity(){
        InnerParam result=null;
        for(InnerParam param: params){
            if(param.getType().equals(parameters.PARAM_QUANTITY)){
                result=param;
                break;
            }
        }
        return result;
    }

//    public boolean containsParam(parameters p){
//        return params.containsKey(p);
//    }

    public void clearParams(){
        params.clear();
    }

    @Override
    public String toString() {
        String result="";
        StringWriter writer=new StringWriter();
        XmlSerializer xml=Xml.newSerializer();

        try {
            xml.setOutput(writer);
            xml.setPrefix("", "");
            xml.startDocument(Charset.defaultCharset().name(), true);
            //xml.startTag("", PACKET);
            xml.startTag("", COMMAND);
            if(cmd!=null) {
                xml.attribute("", NAME, cmd.toString());

                if (params.size() > 0) {
                    xml.startTag("", PARAMS);
                    for (InnerParam param: params) {
                        xml.startTag("", PARAM);
                        if (!map_param_names.containsKey(param.getType())) {
                            utils.logger.get().write("not found value for key: " + param.getType().name());
                        } else {
                            xml.attribute("", TYPE, map_param_names.get(param.getType()));
                            String param_name=param.getName();
                            if(!param_name.isEmpty()) {
                                xml.attribute("", NAME, param.getName());
                            }
                            int nCount = param.getValuesCount();
                            if (nCount > 0) {
                                //xml.startTag("", VALUES);
                                SparseArray<InnerParam.value> values = param.getValues();
                                for (int i = 0; i < values.size(); i++) {
                                    InnerParam.value val = values.get(i);
                                    xml.startTag("", VALUE);

                                    //Value type
                                    xml.attribute("", TYPE, map_value_type_names.get(val.getType()));
                                    String val_name = val.getName();

                                    //value name
                                    if (val_name != null && !val_name.isEmpty()) {
                                        xml.attribute("", NAME, val.getName());
                                    }

                                    //value value
                                    xml.attribute("", VALUE, val.getValue());
                                    xml.endTag("", VALUE);
                                }
                            }
                        }
                        xml.endTag("", PARAM);
                    }
                    xml.endTag("", PARAMS);
                }
            }
            xml.endTag("", COMMAND);
            //xml.endTag("", PACKET);
            xml.endDocument();
        } catch (IOException e) {
            utils.logger.get().write(e.getMessage());
        }

        result=writer.getBuffer().toString();
//        if(BuildConfig.DEBUG){
//            try {
//                File file= new File("/sdcard/Godex.xml");
//                if(file.exists()){
//                    file.delete();
//                }
//                file.createNewFile();
//                FileOutputStream fos = new FileOutputStream(file);
//                fos.write(result.getBytes());
//                fos.close();
//            } catch (Exception e) {
//                utils.logger.get().write(e.toString() + " " + e.getMessage());
//            }
//        }
        return result;
    }

    public class InnerCommand{
        private commands m_cmd= commands.CMD_NONE;

        InnerCommand(commands cmd) throws IllegalStateException {
            if(!map_cmd_names.containsKey(cmd)){
                throw new IllegalStateException();
            }
            m_cmd=cmd;
        }

        @Override
        public String toString() {
            return map_cmd_names.get(m_cmd);
        }

        public commands getType(){
            return m_cmd;
        }
    }

    public class InnerParam{
        private String m_name;
        private parameters pType= parameters.PARAM_NONE;
        private SparseArray<value> values= new SparseArray<>();

        InnerParam(parameters type, String name) {
            pType=type;
            m_name=name;
        }

        InnerParam(parameters type) {
            pType=type;
            m_name="";
        }

        public value addValue(values vType, String name, String value){
            value val=new value(vType, name, value, 0);
            values.append(values.size(), val);
            return val;
        }

        public value addValue(values vType, String name, String value, int nLen){
            value val=new value(vType, name, value, nLen);
            values.append(values.size(), val);

            return val;
        }

        public parameters getType(){
            return pType;
        }

        @Nullable
        public value getValue(String name){

            value result=null;
            for(int i=0; i<values.size(); i++){
                InnerParam.value val=values.get(i);
                if(map_value_type_names.get(val.getType()).equals(name)){
                    result=val;
                    break;
                }
            }
            return result;
        }

        public String getName(){
            return m_name;
        }

        @Nullable
        public value getValue(values vType){
            InnerParam.value result=null;
            for(int i=0; i<values.size(); i++){
                InnerParam.value val=values.get(i);
                if(val.getType().equals(vType)){
                    result=val;
                }
            }
            return result;
        }

        public void clear(){
            values.clear();
        }

        public int getValuesCount(){
            return values.size();
        }

        public SparseArray<value> getValues(){
            return values;
        }

        public class value{
            private String m_name="";
            private String m_val="";
            private values m_type;
            private int m_length=0;
            private error_codes m_errCode=error_codes.ERR_NONE;

            public value(values vType, @Nullable String name, String value, int nLen) {
                m_val=value;
                m_type=vType;
                m_length=nLen;

                if(name!=null) {
                    m_name = name;
                }
            }

            public void setErrCode(error_codes err){
                m_errCode=err;
            }

            public error_codes getErrCode(){
                return m_errCode;
            }

            public String getValue(){
                return (m_val==null ? "" : m_val);
            }

            public int getValueInt(){
                int nResult;
                try {
                    nResult=Integer.parseInt(m_val);
                }catch (NumberFormatException e){
                    nResult=0;
                }
                return nResult;
            }

            public String getName(){
                return m_name;
            }

            public values getType(){
                return m_type;
            }

            public int getLength(){
                return m_length;
            }
        }
    }
}
