package ru.scancode.GodexPrintTest;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.widget.ArrayAdapter;
import android.widget.Toast;

import androidx.fragment.app.FragmentActivity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;

import ru.scancode.GodexPrintTest.activities.MainActivity;
import ru.scancode.GodexPrintTest.dialogs.wait_dlg;
import ru.scancode.GodexPrintTest.fragment.PagePrintTemplateFragment;
import utils.logger;

import static ru.scancode.GodexPrintTest.DataPacker.EXTRA_ANSWER;
import static ru.scancode.GodexPrintTest.DataPacker.EXTRA_DATA;
import static ru.scancode.GodexPrintTest.DataPacker.EXTRA_RESPONSE;
import static ru.scancode.GodexPrintTest.DataPacker.PRINT_ACTION;
import static ru.scancode.GodexPrintTest.DataPacker.resp.RESP_FAIL;
import static ru.scancode.GodexPrintTest.DataPacker.resp.RESP_OK;

//Класс для взаимодействия со службой печати
//====Singleton=====
public class PrintAdapter {
    private wait_dlg d;
    private AlertDialog dlg;
    private static Timer timer;
    private final static int TIME_TO_WAIT = 10;
    private static int nTimeToWait = 0;
    private static ArrayAdapter<PagePrintTemplateFragment.template_label> m_adapter;
    private FragmentActivity context;
    private boolean bTimeOut = false;

    private static PrintAdapter pThis;

    /** Intent который полетит в GodexPrintService */
    private final Intent serv = new Intent();

    private String SERVICE_PACKAGE = "ru.scancode.GodexPrintService";
    private static HashMap<String, String> responseCodes = new HashMap<>();
    private static final String UNEXPECTED_CODE = "UC";
    private static final String ANSWER_NULL = "NULL";

    static {
        responseCodes.put("00", "Ready");
        responseCodes.put("01", "Media empty or media jam");
        responseCodes.put("02", "Media empty or media jam");
        responseCodes.put("03", "Ribbon empty");
        responseCodes.put("04", "Printhead up (Door is open)");
        responseCodes.put("05", "Rewinder full");
        responseCodes.put("06", "File system full");
        responseCodes.put("07", "Filename not found");
        responseCodes.put("08", "Duplicate name");
        responseCodes.put("09", "Syntax error");
        responseCodes.put("10", "Cutter jam");
        responseCodes.put("11", "Extended memory not found");
        responseCodes.put("20", "Pause");
        responseCodes.put("21", "In Setting mode");
        responseCodes.put("22", "In Keyboard mode");
        responseCodes.put("50", "Printer is printing");
        responseCodes.put("60", "Data in process");
        responseCodes.put(UNEXPECTED_CODE, "Unknown state");
    }

    public interface ICallback {
        default void onGetTemplates(List<AbstractPage.template_label> items){};
        default void onGetState(String nCode){};
    }

    private ICallback callback;

    public static PrintAdapter getInstance(FragmentActivity context) {
        if (pThis == null) {
            pThis = new PrintAdapter(context);
        }
        return pThis;
    }

    private PrintAdapter(FragmentActivity context) {
        this.context = context;
    }

    public void setReceiver() {
        if (context != null) {
            //LocalBroadcastManager.getInstance(context).registerReceiver(m_receiver, new IntentFilter(PRINT_ACTION));
            context.registerReceiver(m_receiver, new IntentFilter(PRINT_ACTION));
        }
    }

    public void removeReceiver() {
        if (context != null) {
            context.unregisterReceiver(m_receiver);
        }
    }

    public void getSavedTemplates(ICallback callback) {
        try {
            this.callback = callback;

            DataPacker packet = new DataPacker();
            packet.setCommand(DataPacker.commands.CMD_GET_SAVED_TEMPLATES);

            serv.putExtra(DataPacker.EXTRA_DATA, packet.toString());

            start(serv);

        } catch (Exception e) {
            utils.logger.get().write(e.getMessage());
        }
    }

    public void getPrinterState(ICallback callback) throws IllegalStateException{
        this.callback = callback;

        DataPacker packet= new DataPacker();
        packet.setCommand(DataPacker.commands.CMD_GET_PRINTER_STATUS);

        serv.putExtra(DataPacker.EXTRA_DATA, packet.toString());

        start(serv);
    }

    public void calibrateSensor() {
        DataPacker dPacket = new DataPacker();
        dPacket.setCommand(DataPacker.commands.CMD_SEND_CMD);
        dPacket.addParam(DataPacker.parameters.PARAM_CMD, DataPacker.values.VAL_DATA, null, "~S,SENSOR");

        serv.putExtra(EXTRA_DATA, dPacket.toString());
        start(serv);
    }

    public void getState(ICallback callback) {
        this.callback = callback;
        DataPacker dPacket = new DataPacker();
        dPacket.setCommand(DataPacker.commands.CMD_GET_PRINTER_STATUS);
        dPacket.addParam(DataPacker.parameters.PARAM_CMD, DataPacker.values.VAL_DATA, null, "~S,SENSOR");

        serv.putExtra(EXTRA_DATA, dPacket.toString());
        start(serv);
    }

    public void sendServiceCmd(String data) {

        serv.putExtra(DataPacker.EXTRA_DATA, data);

        Log.d("TAG",data);

        start(serv);
    }

    public void showWaitDialog(Context context) {
        if(dlg == null) {
            dlg = new ProgressDialog.Builder(context)
                    .setTitle(R.string.app_name)
                    .setMessage(R.string.please_wait)
                    .setCancelable(false)
                    .create();
        }

        if (!((Activity) context).isFinishing()) {
            dlg.show();
        }
    }

    public void dismissWaitDialog() {
        if (dlg != null) {
            dlg.dismiss();
            dlg = null;
        }
    }


    public void setTimeout(int nTimeOut) {
        if ((nTimeOut / 100) > 1) {
            nTimeToWait = nTimeOut;
        } else {
            nTimeToWait = nTimeOut * 1000;
        }
    }

    //Сюда приходят ответы от GodexPrintService
    private BroadcastReceiver m_receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null)
                return;

            if (!Objects.equals(intent.getAction(), PRINT_ACTION))
                return;

            if (timer != null) {
                timer.cancel();
                timer.purge();
            }
            dismissWaitDialog();
            //stopWaitDlg();

            //Признак ошибки:
            //0 - ОК
            //1 - ОШИБКА
            int resp = 1;
            try {
                resp = intent.getIntExtra(EXTRA_RESPONSE, RESP_FAIL.ordinal());
                Log.d("resp", String.valueOf(resp));


            } catch (Exception e) {
                String err = context.getString(R.string.unknown_service_answer);
                err += e.getMessage();

                utils.logger.get().write(err);
                Toast.makeText(context, err, Toast.LENGTH_SHORT).show();
                return;
            }

            List<DataPacker.InnerParam> params = new ArrayList<>();

            String answ_str = intent.getStringExtra(EXTRA_ANSWER); //Строка ответа от службы
            if (answ_str != null) {
                logger.get().write("answer: " + answ_str);
                try {
                    //Для удобства разбора XML ответа, ипользуется класс data_packer
                    DataPacker dPacker = new DataPacker(answ_str);
                    params = dPacker.getParams();

                    //Успешное выполнение
                    if (resp == RESP_OK.ordinal()) {
                        DataPacker.InnerCommand cmd = dPacker.getCommand();
                        if (cmd != null) {
                            DataPacker.InnerParam param = dPacker.getResult();
                            switch (cmd.getType()) {
                                case CMD_GET_SAVED_TEMPLATES:
                                    List<AbstractPage.template_label> labels = parse_templates(params);
                                    if (callback != null) {
                                        callback.onGetTemplates(labels);
                                    }
                                    answ_str = "";
                                    break;

                                case CMD_GET_PRINTER_STATUS:
                                    if (callback != null) {
                                        String state = "Wrong answer";

                                        if (param != null) {
                                            DataPacker.InnerParam.value val = param.getValue(DataPacker.values.VAL_DATA);
                                            if (val != null) {
                                                if (val.getValue().equals(ANSWER_NULL)) {
                                                    state = context.getString(R.string.printer_answer_null);
                                                } else {
                                                    answ_str = val.getValue();
                                                    answ_str = answ_str.substring(0, 2);
                                                    answ_str = !responseCodes.containsKey(answ_str) ? UNEXPECTED_CODE : answ_str;
                                                    state = answ_str + "-" + responseCodes.get(answ_str);
                                                }
                                            }
                                        }
                                        callback.onGetState(state);
                                    }
                                    answ_str = "";
                                    break;
                                default:
                                    if (param != null) {
                                        DataPacker.InnerParam.value val = param.getValue(DataPacker.values.VAL_DATA);
                                        if (val != null) {
                                            answ_str = val.getValue();
                                        }
                                    } else {
                                        throw new Exception(context.getString(R.string.unknown_parameter));
                                    }
                                    break;
                            }
                        } else {
                            throw new Exception(context.getString(R.string.unknown_command));
                        }

                        //Ошибка
                    } else if (resp == RESP_FAIL.ordinal()) {
                        DataPacker.InnerParam param = dPacker.getResult();
                        if (param != null) {
                            DataPacker.InnerParam.value val = param.getValue(DataPacker.values.VAL_ERROR);
                            if (val != null) {
                                answ_str = val.getValue();
                                //разбор кодов ошибок
                                switch (val.getErrCode()) {
                                    case ERR_NO_VARS:
                                        AbstractPage page = MainActivity.getLastPage();
                                        if (page != null) {
                                            List<AbstractPage.template_label> labels = parse_templates(params);
                                            if (labels.isEmpty()) {
                                                throw new Exception(answ_str);
                                            }
                                            page.PromptVariables(labels.get(0).getVariables());
                                        }
                                        break;
                                    default:
                                        throw new Exception(answ_str);
                                        //break;
                                }
                            }
                        } else {
                            throw new Exception(context.getString(R.string.unknown_parameter));
                        }
                    }
                } catch (Exception e) {
                    utils.logger.get().write(e.getMessage());
                    answ_str = "error: " + e.getMessage();
                }

                if(answ_str!=null && !answ_str.isEmpty()) {
                    Toast.makeText(context, answ_str, Toast.LENGTH_SHORT).show();
                }

            }
        }
    };

    private List<AbstractPage.template_label> parse_templates(List<DataPacker.InnerParam> params) {
        List<AbstractPage.template_label> result = new ArrayList<>();
        for (DataPacker.InnerParam param : params) {
            if (param.getType().equals(DataPacker.parameters.PARAM_TEMPLATE)) {
                PagePrintTemplateFragment.template_label label = new PagePrintTemplateFragment.template_label(param.getName());
                SparseArray<DataPacker.InnerParam.value> values = param.getValues();
                if (values != null) {
                    for (int i = 0; i < values.size(); i++) {
                        DataPacker.InnerParam.value val = values.get(i);
                        if (val.getType().equals(DataPacker.values.VAL_VARIABLE)) {
                            label.addVariable(new AbstractPage.variable(val.getValue(), val.getName(), val.getLength()));
                        }
                    }
                }
                result.add(label);
            }
        }
        return result;
    }

    private void start(final Intent serviceIntent) {
        logger.get().write();
        bTimeOut = false;
        serviceIntent.setAction(DataPacker.PRINT_ACTION);
        serviceIntent.addCategory(Intent.CATEGORY_DEFAULT);
        serviceIntent.setPackage(SERVICE_PACKAGE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            context.startForegroundService(serviceIntent);
        } else {
            context.startService(serviceIntent);
        }
        //startWaitDlg();
        showWaitDialog(context);

        //Таймер ожидания ответа от службы, что б не зависнуть на долго)
        timer = new Timer();

        timer.schedule(new TimerTask() {
            @Override
            public boolean cancel() {
                utils.logger.get().write("timer canceled");
                Log.d("TAG xml", "iii");

                return super.cancel();
            }

            @Override
            public void run() {
                //bTimeOut=true;
                DataPacker dPack = new DataPacker();
                dPack.setCommand(DataPacker.commands.CMD_NONE);
                dPack.addParam(DataPacker.parameters.PARAM_RESULT, DataPacker.values.VAL_ERROR, null, "timeout");



                serviceIntent.setAction(PRINT_ACTION);
                serviceIntent.putExtra(EXTRA_RESPONSE, DataPacker.resp.RESP_FAIL.ordinal());
                serviceIntent.putExtra(EXTRA_DATA, dPack.toString());
                context.sendBroadcast(serviceIntent);
                dismissWaitDialog();
            }
        }, (nTimeToWait > 0 ? nTimeToWait : TIME_TO_WAIT * 1000));
    }

}
