package ru.scancode.GodexPrintTest.activities;

import static ru.scancode.GodexPrintTest.fragment.XMLPageFragment.PAGENAME;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.Settings;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.snackbar.Snackbar;

import java.util.List;

import ru.scancode.GodexPrintTest.AbstractPage;
import ru.scancode.GodexPrintTest.BuildConfig;
import ru.scancode.GodexPrintTest.R;
import ru.scancode.GodexPrintTest.fragment.DebugPageFragment;
import ru.scancode.GodexPrintTest.fragment.OneCEmulatorFragment;
import ru.scancode.GodexPrintTest.fragment.PageImageTestFragment;
import ru.scancode.GodexPrintTest.fragment.PagePrintCmdFileFragment;
import ru.scancode.GodexPrintTest.fragment.PagePrintCustomCommandFragment;
import ru.scancode.GodexPrintTest.fragment.PagePrintTemplateFragment;
import ru.scancode.GodexPrintTest.fragment.XMLPageFragment;
import ru.scancode.GodexPrintTest.PrintAdapter;
import utils.logger;

public class MainActivity extends AppCompatActivity {
    private int nActivePage=0;
    private page_template tmpl;
    private EditText editQuantity;
    private Button btnPrint;
    private Button btnCalibrate;
    private PrintAdapter printService;
    private static AbstractPage last_page;
    private MenuItem menu_item;
    private Activity activity;
    private AlertDialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_client);

        this.activity = this;

        if (isStoragePermissionGranted()) {
            logger.get().write("Permissions is granted");
        }

        editQuantity=findViewById(R.id.editCount);
        btnPrint=findViewById(R.id.btnPrint);
        btnCalibrate = findViewById(R.id.btnCalibrate);

        tmpl=new page_template(getSupportFragmentManager(), this);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            if (!Environment.isExternalStorageManager()) {
                Intent intent = new Intent(Settings.ACTION_MANAGE_APP_ALL_FILES_ACCESS_PERMISSION);
                intent.setData(Uri.parse("package:" + getPackageName()));
                startActivity(intent);
            }
        }

        tmpl.addPage(new PagePrintTemplateFragment(),           getString(R.string.print_template));
        tmpl.addPage(new PagePrintCustomCommandFragment(),  getString(R.string.print_custom_cmd));
        tmpl.addPage(new PagePrintCmdFileFragment(),            getString(R.string.print_cmd_file));
        tmpl.addPage(new XMLPageFragment(), PAGENAME);
        tmpl.addPage(new OneCEmulatorFragment(), "Печать с выбранным CMD файлом");
        if (BuildConfig.DEBUG) {


           /* Задел на будующее
           tmpl.addPage(new DebugPageFragment(), "debug");
           tmpl.addPage(new PageImageTestFragment(), "Images");*/
        }

        ViewPager viewPager =findViewById(R.id.pager);
        viewPager.setAdapter(tmpl);
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageSelected(int position) {
                nActivePage= position;
                boolean bEnable=false;
                switch(nActivePage){
                    case 0:
                        bEnable=true;
                        break;
                    case 2:
                        btnPrint.setText(R.string.execute);
                        break;
                    case 4:
                        btnPrint.setText(R.string.send);
                        break;
                    default:
                        btnPrint.setText(R.string.print);
                        break;
                }

                if(menu_item !=null) {
                    menu_item.setEnabled(bEnable);
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }

            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                nActivePage=position;
            }
        });

        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);


        init();

//        if(BuildConfig.DEBUG){
//            viewPager.setCurrentItem(tmpl.getCount()-1);
//        }

        Button btnGetPrinterState = findViewById(R.id.btnState);
        if(btnGetPrinterState != null){
            btnGetPrinterState.setOnClickListener(v -> getState());
        }


    }

    private void init(){
        printService= PrintAdapter.getInstance(this);
        printService.setReceiver();
    }

    private void close(){
        printService= PrintAdapter.getInstance(this);
        printService.removeReceiver();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.act_menu, menu);
        menu_item = menu.findItem(R.id.menuRefreshTemplates);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch(item.getItemId()){
            case R.id.menuRefreshTemplates:
                getTemplates();
                break;
            case R.id.menuGetState:
                getState();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onPause() {
        super.onPause();
        close();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if(getSupportFragmentManager().isStateSaved()){
            getSupportFragmentManager().popBackStackImmediate();
        }
        init();
    }

    public void onBtnCalibrateClick(View view){
        printService.calibrateSensor();
    }

    public void onBtnStateClick(View view) {
        getState();
    }

    public void onBtnGetTemplatesClick(View view){
        getTemplates();
    }

    public static AbstractPage getLastPage(){
        return last_page;
    }

    public void onBtnPrintClick(View view){
        last_page=tmpl.getPage(nActivePage);
        if(last_page==null) {
            utils.logger.get().write("not page found");
            return;
        }

        int nQuantity=1;
        try{
            nQuantity=Integer.parseInt(editQuantity.getText().toString());
        }
        catch (NumberFormatException e){
            nQuantity=1;
        }

        last_page.setQuantity(nQuantity);

        SparseArray<AbstractPage.variable> vars=last_page.getVariables();
        if(vars.size()>0){
            last_page.PromptVariables(vars);
        }
        else {
            String data = last_page.getPrintData();

            if (data == null || data.isEmpty() || nQuantity <= 0) {
                String msg = getString(R.string.no_data);
                utils.logger.get().write(msg);
                Snackbar.make(editQuantity, msg, Snackbar.LENGTH_LONG);
            }
            else{
                printService.sendServiceCmd(data);
            }
        }
    }

    private class page_template extends FragmentPagerAdapter {
        private SparseArray<AbstractPage> pages= new SparseArray<>();

        page_template(FragmentManager fm, FragmentActivity context) {
            super(fm, BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
        }

        void addPage(AbstractPage page, String title) throws IllegalStateException {
            if(pages.indexOfValue(page)<0) {
                Bundle args= new Bundle();
                args.putString(AbstractPage.ARG_TITLE, title);

                page.setArguments(args);
                pages.append(pages.size(), page);
            }
            else{
                throw new IllegalStateException(getString(R.string.key_already_exists));
            }
        }

        @Nullable
        public AbstractPage getPage(int position){
            AbstractPage result=null;
            if(pages.indexOfKey(position)>=0){
                result=pages.get(position);
            }
            return result;
        }

        @Override
        public int getCount() {
            return pages.size();
        }

        @Override
        public Fragment getItem(int position) {
            AbstractPage result=null;

            if(pages.indexOfKey(position)>=0){
                result=pages.get(position);
            }
            return result;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            AbstractPage page=pages.get(position);
            String title="";
            if(page!=null){
                title=page.getTitle();
            }
            return title;
        }
    }

    private boolean isStoragePermissionGranted() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (checkSelfPermission(android.Manifest.permission.WRITE_EXTERNAL_STORAGE)
                    == PackageManager.PERMISSION_GRANTED) {
                logger.get().write( "Permission is granted");
                return true;
            } else {
                logger.get().write("Permission is revoked");
                ActivityCompat.requestPermissions(this, new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, 1);
                return false;
            }
        } else { //permission is automatically granted on sdk<23 upon installation
            logger.get().write( "Permission is granted");
            return true;
        }
    }

    private void getTemplates() {
        printService.getSavedTemplates(new PrintAdapter.ICallback() {
            @Override
            public void onGetTemplates(List<AbstractPage.template_label> items) {
                PagePrintTemplateFragment.adapter.clear();
                for(AbstractPage.template_label label: items){
                    PagePrintTemplateFragment.adapter.add(label);
                }
                PagePrintTemplateFragment.adapter.notifyDataSetChanged();
            }
        });
    }

    private void getState() {
        dialog = new AlertDialog.Builder(this)
                .setTitle(R.string.printer_state)
                .setMessage(R.string.please_wait)
                .setCancelable(false)
                .setPositiveButton(R.string.open_go, (dialog, which) -> dialog.dismiss())
                .create();

        printService.getPrinterState(new PrintAdapter.ICallback() {
            @Override
            public void onGetState(String state) {
                dialog.setMessage(state);
                dialog.show();
            }
        });
    }

}
