package ru.scancode.GodexPrintTest.dialogs;

import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.text.InputFilter;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;

import ru.scancode.GodexPrintTest.AbstractPage;
import ru.scancode.GodexPrintTest.R;
import ru.scancode.GodexPrintTest.fragment.PagePrintTemplateFragment;

public class VariablePromptDialog extends DialogFragment {

    private TextView tvVar;
    private EditText edValue;
    private SparseArray<AbstractPage.variable> variables;
    private LinearLayout group;

    public interface IEditorListener{
        void OnDialogResult(@NonNull SparseArray<AbstractPage.variable> result);
        void OnDissmissDalog();
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        dismissAllowingStateLoss();
    }

    @NonNull
    @Override
    @SuppressWarnings("unchecked")
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            setStyle(STYLE_NORMAL, android.R.style.Theme_Material_Light_Dialog_Alert);
        }
        Bundle args=getArguments();
        if(args!=null){
            if(args.containsKey(AbstractPage.EXTRA_VARIABLE)){
                variables =args.getSparseParcelableArray(PagePrintTemplateFragment.EXTRA_VARIABLE);
                //variables = (SparseArray<AbstractPage.variable>)obj;
            }
        }
        return super.onCreateDialog(savedInstanceState);
    }

    private void getVariablesValues(){
        for(int i=0; i<group.getChildCount(); i++){
            View view=group.getChildAt(i);

            if(view instanceof EditText){
                int nKey=(int)view.getTag();
                if(nKey>=0){
                    AbstractPage.variable v=variables.get(nKey);
                    v.value=((EditText) view).getText().toString();
                    variables.put(nKey, v);
                }
            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View result=inflater.inflate(R.layout.variable_prompt_dialog, container, false);
        getDialog().setTitle(R.string.prompt_variable_value);
        getDialog().setCanceledOnTouchOutside(false);
        getDialog().setCancelable(true);

        group = result.findViewById(R.id.insert_point);
        group.setOverScrollMode(View.OVER_SCROLL_IF_CONTENT_SCROLLS);
        group.setOrientation(LinearLayout.VERTICAL);
        for(int i =0; i<variables.size(); i++){
            AbstractPage.variable v=variables.get(i);
            String prompt=v.prompt;// it.next();

            TextView tvName=new TextView(group.getContext());
            tvName.setText(prompt);
            group.addView(tvName);

            EditText edValue=new EditText(group.getContext());
            edValue.setSingleLine();
            edValue.setText(v.value);
            edValue.setImeOptions(i == variables.size() -1 ? EditorInfo.IME_ACTION_DONE : EditorInfo.IME_ACTION_NEXT);
            edValue.setTag(i);

            int maxLength =v.nLen;
            InputFilter[] FilterArray = new InputFilter[1];
            FilterArray[0] = new InputFilter.LengthFilter(maxLength);
            edValue.setFilters(FilterArray);

            group.addView(edValue);
        }

        Button btn = new Button(group.getContext());
        btn.setText(R.string.print);
        btn.setOnClickListener(v -> {
            IEditorListener listener =(IEditorListener)getTargetFragment();
            if (listener != null) {
               getVariablesValues();
                listener.OnDialogResult(variables);
            }
        });
        group.addView(btn);
        return result;
    }

}
