package ru.scancode.GodexPrintTest.fragment;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import ru.scancode.GodexPrintTest.AbstractPage;
import ru.scancode.GodexPrintTest.utils.MonochromeBMPUtil;
import ru.scancode.GodexPrintTest.R;
import ru.scancode.GodexPrintTest.DataPacker;
import ru.scancode.GodexPrintTest.PrintAdapter;
import ru.scancode.GodexPrintTest.dialogs.VariablePromptDialog;
import utils.dialogDirPicker;

public class PageImageTestFragment extends AbstractPage implements VariablePromptDialog.IEditorListener {
    private ListView lstTemplates;
    private EditText editSrcPath;
    private EditText editImageId;
    private Button btnGetSrc;
    private Button btnDeleteInPrinter;
    private String source;
    private ImageView sourceImage;
    private ImageView convertedImage;
    private Bitmap sourceBitmap;
    private String workPath;

    private template_label label;

    private List<template_label> values = new ArrayList<>();
//    private static PageImageTest.TemplatesAdapter adapter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (m_parentActivity != null) {
//            adapter = new PageImageTest.TemplatesAdapter(m_parentActivity, values);
//            printAdapter.getInstance(m_parentActivity).getSavedTemplates(labels -> {
//                pagePrintTemplate.adapter.clear();
//                for(AbstractPage.template_label label: labels){
//                    pagePrintTemplate.adapter.add(label);
//                }
//                pagePrintTemplate.adapter.notifyDataSetChanged();
//            });
        } else {
            utils.logger.get().write("PageImageTest.onCreate: m_parentActivity is null!!!");
        }



    }



    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View view = inflater.inflate(R.layout.page_image_test, container, false);

        btnGetSrc = view.findViewById(R.id.btnPickSource);
        btnGetSrc.setOnClickListener(clickListener);
        btnDeleteInPrinter = view.findViewById(R.id.btnDeleteInPrinter);
        btnDeleteInPrinter.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                sendDeleteCmd();
            }
        });
        editSrcPath = view.findViewById(R.id.editSrcPath);
        editImageId = view.findViewById(R.id.editImageId);
        sourceImage = view.findViewById(R.id.sourceImage);
        convertedImage = view.findViewById(R.id.convertedImage);

        return view;
    }

    private void sendDeleteCmd() {
        PrintAdapter printService = PrintAdapter.getInstance(getActivity());
        String data = "";
        DataPacker packer = new DataPacker();
        try {
            String img_id = editImageId.getText().toString();
            packer.setCommand(DataPacker.commands.CMD_DELETE_IMAGE);
            param = packer.addParam(DataPacker.parameters.PARAM_IMG, DataPacker.values.VAL_DATA, "", img_id);
            data = packer.toString();
        } catch (Exception e) {
            utils.logger.get().write(e.getMessage());
        }
        if (data.isEmpty()) {
            String msg = getString(R.string.no_data);
        } else {
            printService.sendServiceCmd(data);
        }
    }

    private void setConvertedImage() {
        String convertedImageString = workPath + "/convertedImage.bmp";
        Log.i("LOGTAG", convertedImageString);

        if (MonochromeBMPUtil.save(sourceBitmap, convertedImageString, 100)) {
            File convertedImageFile = new File(convertedImageString);
            sourceBitmap = BitmapFactory.decodeFile(convertedImageFile.getAbsolutePath());
            convertedImage.setImageBitmap(sourceBitmap);
        } else {
            Toast.makeText(m_parentActivity, "converting failed", Toast.LENGTH_SHORT).show();
        }
    }

    private View.OnClickListener clickListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            switch (v.getId()) {
                case R.id.btnPickSource:
                    Intent intent = new Intent(m_parentActivity, utils.dialogDirPicker.class);
                    intent.addCategory(Intent.CATEGORY_DEFAULT);
                    intent.putExtra(dialogDirPicker.EXTRA_FILTER, ".jpg;.jpeg;.bmp;.png;.gif");
                    intent.putExtra(dialogDirPicker.EXTRA_BEGIN_DIR, editSrcPath.getText().toString());
                    startActivityForResult(intent, 0);
                    break;
            }
        }
    };

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == Activity.RESULT_OK) {
            source = data.getStringExtra(dialogDirPicker.EXTRA_RESULT);
            if (source != null && source.isEmpty()) {
                editSrcPath.getText().clear();
            } else {
                editSrcPath.setText(source);
                setSourceImage(source);
            }
        }
    }

    private void setSourceImage(String source) {
        File sourceImageFile = new File(source);
        workPath = sourceImageFile.getAbsolutePath();
        workPath = workPath.substring(0, workPath.lastIndexOf("/"));
        sourceBitmap = BitmapFactory.decodeFile(sourceImageFile.getAbsolutePath());
        sourceImage.setImageBitmap(sourceBitmap);

    }

    @Override
    public SparseArray<variable> getVariables() {
        variables.clear();
        return variables;
    }


    @Override
    public void PromptVariables(SparseArray<variable> vars) {

    }

    @Override
    public String getPrintData() {
        String result = "";

        DataPacker packer = new DataPacker();
        try {
            packer.setCommand(DataPacker.commands.CMD_LOAD_IMG_TO_PRINTER);
            param = packer.addParam(DataPacker.parameters.PARAM_IMG, DataPacker.values.VAL_PATH, "", source);
            String img_id = editImageId.getText().toString();
            param.addValue(DataPacker.values.VAL_DATA, "", img_id);

            result = packer.toString();
        } catch (Exception e) {
            utils.logger.get().write(e.getMessage());
        }

        return result;
    }

    @Override
    public void OnDissmissDalog() {
        bPromptDialogIsShown = false;
    }

    @Override
    public void OnDialogResult(@NonNull SparseArray<variable> result) {

        param.clear();

//        Iterator<String> it=result.keySet().iterator();
//        while(it.hasNext()){
//            String key=it.next();
//            String value=result.get(key).value;
//            param.addValue(data_packer.values.VAL_VARIABLE, key, value);
//        }
        for (int i = 0; i < result.size(); i++) {
            variable v = result.get(i);
            param.addValue(DataPacker.values.VAL_VARIABLE, v.prompt, v.value, v.nLen);
        }
        PrintAdapter.getInstance(m_parentActivity).sendServiceCmd(packer.toString());
    }

    private void dismissDlg() {
        if (dlg != null) {
            dlg.dismissAllowingStateLoss();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        dismissDlg();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        dismissDlg();
    }

//    class TemplatesAdapter extends ArrayAdapter<template_label> {
//        private final List<template_label> m_values;
//        private LayoutInflater inflater;
//        private int res = android.R.layout.simple_list_item_single_choice;//R.layout.checkable_layout;
//
//        TemplatesAdapter(@NonNull Context context, List<template_label> values) {
//            super(context, -1, values);
//            this.m_values = values;
//            this.inflater = LayoutInflater.from(context);
//        }
//
//        @NonNull
//        @Override
//        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
//
//            PageImageTest.TemplatesAdapter.ViewHolder holder;
//            if (convertView == null) {
//                convertView = inflater.inflate(res, parent, false);
//                holder = new PageImageTest.TemplatesAdapter.ViewHolder(convertView);
//                convertView.setTag(holder);
//            } else {
//                holder = (PageImageTest.TemplatesAdapter.ViewHolder) convertView.getTag();
//            }
//
//            holder.text.setText(m_values.get(position).m_name);
//
//            return convertView;
//        }
//
//        @Override
//        public int getCount() {
//            return m_values.size();
//        }
//
//        @Override
//        public void add(@Nullable template_label object) {
//            m_values.add(object);
//        }
//
//        private class ViewHolder {
//            final TextView text;
//            //final CheckBox chBox;
//
//            public ViewHolder(View view) {
//                text = view.findViewById(android.R.id.text1);
//                //chBox=view.findViewById()
//            }
//        }
//    }

}
