package ru.scancode.GodexPrintTest.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.MediaScannerConnection;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import android.os.Environment;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.TextView;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import ru.scancode.GodexPrintTest.AbstractPage;
import ru.scancode.GodexPrintTest.R;
import ru.scancode.GodexPrintTest.DataPacker;
import ru.scancode.GodexPrintTest.PrintAdapter;
import ru.scancode.GodexPrintTest.dialogs.VariablePromptDialog;
import utils.dialogDirPicker;

//Класс для реализации печати из CMD файла

public class PagePrintCmdFileFragment extends AbstractPage implements VariablePromptDialog.IEditorListener {
    private TextView editPathCmd;
    private TextView editPathSrc;
    private RadioButton filePath,fileXml;
    private final int REQUEST_CMD=0;
    private final int REQUEST_SRC=1;
    private String pathCmd ="";
    private String pathSrc ="";
    private String xmlFile = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter name=\"stasprichepa1.cmd\" type=\"cmd_file\">\n" +
            "\t\t\t<value type=\"path\" value=\"\"/>\n" +
            "\t\t\t<value name=\"V00\" type=\"variable\" value=\"Code=000001|UnitCode=796|Characteristic=Белый, 200 х 60 х 50|MDM_key=ca0fae48-92b1-406f-bfe2-90665c9808e5|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\"/>\n" +
            "\t\t\t<value name=\"V01\" type=\"variable\" value=\"Х-67890 Стинол Завод бытовой техники\"/>\n" +
            "\t\t\t<value name=\"V02\" type=\"variable\" value=\"000001\"/>\n" +
            "\t\t\t<value name=\"V03\" type=\"variable\" value=\"Белый, 200 х 60 х 50\"/>\n" +
            "\t\t\t<value name=\"V04\" type=\"variable\" value=\"шт (1 шт)\"/>\n" +
            "\t\t\t<value name=\"V05\" type=\"variable\" value=\"1234567\"/>\n" +
            "\t\t\t<value name=\"V06\" type=\"variable\" value=\"qwerty\"/>\n" +
            "\t\t\t<value name=\"V07\" type=\"variable\" value=\"cdr56yhn\"/>\n" +
            "\t\t\t<value name=\"V08\" type=\"variable\" value=\"5rtfgvhyu8ijk\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";


    private String xmlFile2 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter name=\"stasprichepa1.cmd\" type=\"cmd_file\">\n" +
            "\t\t\t<value name=\"QRCode\" type=\"variable\" value=\"Code=000001|UnitCode=796|Characteristic=Белый, 200 х 60 х 50|MDM_key=ca0fae48-92b1-406f-bfe2-90665c9808e5|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\"/>\n" +
            "\t\t\t<value name=\"Name\" type=\"variable\" value=\"Х-67890 Стинол Завод бытовой техники\"/>\n" +
            "\t\t\t<value name=\"Code\" type=\"variable\" value=\"000001\"/>\n" +
            "\t\t\t<value name=\"Characteristic\" type=\"variable\" value=\"Белый, 200 х 60 х 50\"/>\n" +
            "\t\t\t<value name=\"MeasureUnit\" type=\"variable\" value=\"шт (1 шт)\"/>\n" +
            "\t\t\t<value name=\"SerName\" type=\"variable\" value=\"\"/>\n" +
            "\t\t\t<value name=\"ExpDate\" type=\"variable\" value=\"\"/>\n" +
            "\t\t\t<value name=\"Shipper\" type=\"variable\" value=\"\"/>\n" +
            "\t\t\t<value name=\"Supplier\" type=\"variable\" value=\"\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"0\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private View.OnClickListener clickListener= new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Intent intent = new Intent(getContext(), utils.dialogDirPicker.class);
            intent.addCategory(Intent.CATEGORY_DEFAULT);

            switch(v.getId()){
                case R.id.btnGetPath:
                    intent.putExtra(dialogDirPicker.EXTRA_FILTER, ".cmd");
                    intent.putExtra(dialogDirPicker.EXTRA_BEGIN_DIR, editPathCmd.getText().toString());

                    startActivityForResult(intent, REQUEST_CMD);
                break;
                case R.id.btnPickSource:
                    intent.putExtra(dialogDirPicker.EXTRA_FILTER, ".txt;.xls;.xml;.db");
                    intent.putExtra(dialogDirPicker.EXTRA_BEGIN_DIR, editPathSrc.getText().toString());
                    startActivityForResult(intent, REQUEST_SRC);
                    break;
            }
        }
    };

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(resultCode== Activity.RESULT_OK) {
            switch (requestCode) {
                case REQUEST_CMD:
                    pathCmd = data.getStringExtra(utils.dialogDirPicker.EXTRA_RESULT);
                    break;
                case REQUEST_SRC:
                    pathSrc = data.getStringExtra(utils.dialogDirPicker.EXTRA_RESULT);
                    break;
            }
            editPathCmd.setText(pathCmd);
            editPathSrc.setText(pathSrc);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View result=null;
        if(inflater!=null) {
            result = inflater.inflate(R.layout.print_cmd_file_page, container, false);

            editPathCmd = result.findViewById(R.id.editFilePath);
            editPathSrc = result.findViewById(R.id.editSrcPath);


            Button btnPickFile = result.findViewById(R.id.btnGetPath);
            Button btnGetSource = result.findViewById(R.id.btnPickSource);

            btnPickFile.setOnClickListener(clickListener);
            btnGetSource.setOnClickListener(clickListener);
            btnPickFile.requestFocus();
        }
        return result;
    }

    @Override
    public SparseArray<variable> getVariables() {
        return variables;
    }

    private DataPacker InitPrintData(String template){
        //Начальная инициализация пакета с данными для посылки в service
        DataPacker packer = new DataPacker();
        try {
            packer.setCommand(DataPacker.commands.CMD_PRINT);
            packer.addParam(DataPacker.parameters.PARAM_QUANTITY, DataPacker.values.VAL_COUNT, "", m_quantity);
            param = packer.addParam(DataPacker.parameters.PARAM_CMD_FILE, template);
        }
        catch(Exception e){
            utils.logger.get().write(e.toString() + " " + e.getMessage());
        }
        return packer;
    }

    @Override
    public void PromptVariables(SparseArray<variable> vars) {
        pathCmd=editPathCmd.getText().toString();
        packer =InitPrintData(pathCmd);

        Bundle args= new Bundle();
        args.putSparseParcelableArray(EXTRA_VARIABLE, vars);

        dlg = new VariablePromptDialog();
        dlg.setArguments(args);
        dlg.setTargetFragment(this, REQUEST_ANSWER_CODE);
        dlg.show(m_parentActivity.getSupportFragmentManager(), "");
        bPromptDialogIsShown=true;
    }

    //Возвращает строку XML в MainActivity при нажатии кнопки ПЕЧАТЬ
    @Override
    public String getPrintData() {
        String result="";
        try {
            pathCmd=editPathCmd.getText().toString(); //Путь к cmd-файлу
            pathSrc=editPathSrc.getText().toString(); //Путь к файлу-источнику данных
            packer =InitPrintData(pathCmd);

            if(pathSrc!=null && !pathSrc.isEmpty()) {
                param.addValue(DataPacker.values.VAL_PATH, null, pathSrc);
                //Log.d("uiop",param.getValues().toString());//путь к файлу-источнику данных
//                Intent launchIntent = new Intent();
//                launchIntent.setAction("mobile_print_action");
//                launchIntent.putExtra("data",packer.toString());
//                launchIntent.setClassName(
//                        "ru.scancode.GodexPrintService",
//                        "ru.scancode.GodexPrintService.activities.ClientActivity"
//                );
//                startActivity(launchIntent);
            }
//            if(filePath.isChecked()){
//                if(pathSrc!=null && !pathSrc.isEmpty()) {
//                    param.addValue(DataPacker.values.VAL_PATH, null, pathSrc); //путь к файлу-источнику данных
//                }
//            }
//            if(fileXml.isChecked()){
//                //param.addValue(DataPacker.values.VAL_DATA, null, xmlFile2); //путь к файлу-источнику данных

//            }

            Log.d("TAG",packer.toString());
            result= packer.toString();

        } catch (Exception e) {
            utils.logger.get().write(e.getMessage());
        }

        Log.d("TAGR",result.toString());

        return result;
    }


    public static String parseValuesToFile(Context context, String xmlFilePath) {
        File xmlFile = new File(xmlFilePath);
        if (!xmlFile.exists()) {
            return null;
        }

        try {
            // 1. Парсинг XML
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(xmlFile);

            // 2. Извлечение значений
            List<String> values = extractValues(doc);

            // 3. Создание файла во внутреннем хранилище
            File outputDir = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
            File outputFile = new File(outputDir, "xml_values_output.txt");
            MediaScannerConnection.scanFile(
                    context,
                    new String[]{outputFile.getAbsolutePath()},
                    null,
                    null
            );
            // 4. Запись результатов
            writeResultsToFile(outputFile, values);

            return outputFile.getAbsolutePath();

        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<String> extractValues(Document doc) {
        List<String> values = new ArrayList<>();
        NodeList valueNodes = doc.getElementsByTagName("value");

        for (int i = 0; i < valueNodes.getLength(); i++) {
            Node node = valueNodes.item(i);
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                Element element = (Element) node;
                String value = element.getAttribute("value");
                if (!value.isEmpty()) {
                    values.add(value);
                }
            }
        }
        return values;
    }

    private static void writeResultsToFile(File outputFile, List<String> values) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile))) {
            writer.write(String.join(",", values));
        }
    }

    @Override
    public void OnDissmissDalog() {
        bPromptDialogIsShown=false;
    }

    @Override
    public void OnDialogResult(@NonNull SparseArray<variable> result) {

        param.clear();
        pathCmd=editPathCmd.getText().toString();
        param.addValue(DataPacker.values.VAL_PATH, null, pathCmd);

//        Iterator<String> it=result.keySet().iterator();
//        int i=0;
//        while(it.hasNext()){
//            String key=it.next();
//            String value=result.get(key).value;
//            String varName="V" + i;
//            param.addValue(data_packer.values.VAL_VARIABLE, varName, value);
//            i++;
//        }

        for(int i=0; i<result.size(); i++){
            variable v=result.get(i);
            String varName="V" + i;
            param.addValue(DataPacker.values.VAL_VARIABLE, varName, v.value);
        }
        PrintAdapter.getInstance(m_parentActivity).sendServiceCmd(packer.toString());
    }

    private void dismissDlg(){
        if(dlg!=null){
            dlg.dismissAllowingStateLoss();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        dismissDlg();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        dismissDlg();
    }
}
