package ru.scancode.GodexPrintTest.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import ru.scancode.GodexPrintTest.AbstractPage;
import ru.scancode.GodexPrintTest.R;
import ru.scancode.GodexPrintTest.DataPacker;
import ru.scancode.GodexPrintTest.PrintAdapter;
import ru.scancode.GodexPrintTest.dialogs.VariablePromptDialog;
import utils.dialogDirPicker;
import utils.logger;

public class PagePrintTemplateFragment extends AbstractPage implements VariablePromptDialog.IEditorListener {
    private ListView lstTemplates;
    private EditText editSrcPath;
    //private TextView editSrcPath;
    private String source;

    private final List<template_label> values= new ArrayList<>();
    public static TemplatesAdapter adapter;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onResume() {
        super.onResume();
        logger.get().write("pagePrintTemplate onResume");
        if(m_parentActivity !=null) {
            adapter = new TemplatesAdapter(m_parentActivity, values);
            lstTemplates.setAdapter(adapter);
            PrintAdapter.getInstance(m_parentActivity).getSavedTemplates(new PrintAdapter.ICallback() {
                    @Override
                    public void onGetTemplates(List<template_label> items) {
                        adapter.clear();
                        for (AbstractPage.template_label label : items) {
                            adapter.add(label);
                        }
                        adapter.notifyDataSetChanged();
                    }

                @Override
                public void onGetState(String state) {
                }
                });
        }
        else{
            utils.logger.get().write("pagePrintTemplate.onCreate: m_parentActivity is null!!!");
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View result=inflater.inflate(R.layout.print_saved_template_page, container, false);

        lstTemplates =result.findViewById(R.id.lstTemplates);
        lstTemplates.setAdapter(adapter);
        lstTemplates.requestFocus();

        Button btnGetSrc = result.findViewById(R.id.btnPickSource);
        btnGetSrc.setOnClickListener(clickListener);

        editSrcPath =result.findViewById(R.id.editSrcPath);

        lstTemplates.setOnItemClickListener((parent, view, position, id) -> {
        });
        return result;
    }

    private final View.OnClickListener clickListener = (v) -> {
            switch(v.getId()){
                case R.id.btnPickSource:
                    Intent intent = new Intent(m_parentActivity, utils.dialogDirPicker.class);
                    intent.addCategory(Intent.CATEGORY_DEFAULT);
                    intent.putExtra(dialogDirPicker.EXTRA_FILTER, ".txt;.xls;.xml;.db;.csv");
                    intent.putExtra(dialogDirPicker.EXTRA_BEGIN_DIR, editSrcPath.getText().toString());
                    startActivityForResult(intent, 0);
                    break;
            }
        };

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(requestCode==0 && resultCode== Activity.RESULT_OK){
            source=data.getStringExtra(dialogDirPicker.EXTRA_RESULT);
            if(source.isEmpty()){
                editSrcPath.getText().clear();
            }
            else {
                editSrcPath.setText(source);
            }
        }
    }

    @Override
    public SparseArray<variable> getVariables() {
        int nCheckedPos = lstTemplates.getCheckedItemPosition();
        if(nCheckedPos >=0) {
            template_label label = adapter.getItem(nCheckedPos);
            if (label != null) {
                variables = label.getVariables();
            }

            if (!editSrcPath.getText().toString().isEmpty()) {
                variables.clear();
            }
        }
        return variables;
    }

    private DataPacker InitPrintData(String template){
        DataPacker packer =new DataPacker();
        try {
            packer.setCommand(DataPacker.commands.CMD_PRINT);
            packer.addParam(DataPacker.parameters.PARAM_QUANTITY, DataPacker.values.VAL_COUNT, "", m_quantity);
            param = packer.addParam(DataPacker.parameters.PARAM_TEMPLATE, template);
        }
        catch(Exception e){
            utils.logger.get().write(e.toString() + " " + e.getMessage());
        }
        return packer;
    }

    @Override
    public void PromptVariables(SparseArray<variable> vars) {
        int nCheckedPos=lstTemplates.getCheckedItemPosition();
        template_label label = adapter.getItem(nCheckedPos);

        packer =InitPrintData(label.m_name);

        Bundle args= new Bundle();
        args.putSparseParcelableArray(EXTRA_VARIABLE, vars);

        dlg = new VariablePromptDialog();
        dlg.setArguments(args);
        dlg.setTargetFragment(this, REQUEST_ANSWER_CODE);
        dlg.show(m_parentActivity.getSupportFragmentManager(), "");
        bPromptDialogIsShown=true;
    }

    @Override
    public String getPrintData() {
        String result="";
        try {
            int nCheckedPos=lstTemplates.getCheckedItemPosition();
            template_label label = adapter.getItem(nCheckedPos);

            if(label!=null) {
                packer = InitPrintData(label.m_name);
                param.addValue(DataPacker.values.VAL_PATH, null, source); //путь к файлу-источнику данных
            }
            result= packer.toString();
        } catch (Exception e) {
            utils.logger.get().write(e.getMessage());
        }

        return result;
    }

    @Override
    public void OnDissmissDalog() {
        bPromptDialogIsShown=false;
    }

    @Override
    public void OnDialogResult(@NonNull SparseArray<variable> result) {

        param.clear();

//        Iterator<String> it=result.keySet().iterator();
//        while(it.hasNext()){
//            String key=it.next();
//            String value=result.get(key).value;
//            param.addValue(data_packer.values.VAL_VARIABLE, key, value);
//        }
        for(int i=0; i<result.size(); i++) {
            variable v=result.get(i);
            param.addValue(DataPacker.values.VAL_VARIABLE, v.prompt, v.value, v.nLen);
        }
        PrintAdapter.getInstance(m_parentActivity).sendServiceCmd(packer.toString());
    }

    private void dismissDlg(){
        if(dlg!=null){
            dlg.dismissAllowingStateLoss();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
       dismissDlg();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        dismissDlg();
    }

    public class TemplatesAdapter extends ArrayAdapter<template_label>{
        private final List<template_label> m_values;
        private LayoutInflater inflater;
        private int res=android.R.layout.simple_list_item_single_choice;//R.layout.checkable_layout;

        TemplatesAdapter(@NonNull Context context, List<template_label> values) {
            super(context, -1, values);
            this.m_values=values;
            this.inflater=LayoutInflater.from(context);
        }

        @NonNull
        @Override
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {

            ViewHolder holder;
            if(convertView==null){
                convertView=inflater.inflate(res, parent, false);
                holder = new ViewHolder(convertView);
                convertView.setTag(holder);
            }else{
                holder=(ViewHolder)convertView.getTag();
            }

            holder.text.setText(m_values.get(position).m_name);

            return convertView;
        }

        @Override
        public int getCount() {
            return m_values.size();
        }

        @Override
        public void add(@Nullable template_label object) {
            m_values.add(object);
        }

        private class ViewHolder{
            final TextView text;
            //final CheckBox chBox;

            public ViewHolder(View view) {
                text=view.findViewById(android.R.id.text1);
                //chBox=view.findViewById()
            }
        }
    }

}
