package ru.scancode.GodexPrintTest.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import ru.scancode.GodexPrintTest.AbstractPage;
import ru.scancode.GodexPrintTest.DataPacker;
import ru.scancode.GodexPrintTest.R;
import ru.scancode.GodexPrintTest.PrintAdapter;
import ru.scancode.GodexPrintTest.dialogs.VariablePromptDialog;
import utils.dialogDirPicker;

/**
 * Вкладка тестирования отправки параметров (в т.ч. QR) в XML-формате
 *
 * @author Vaganov
 */
public class XMLPageFragment extends AbstractPage implements VariablePromptDialog.IEditorListener {

    public static String PAGENAME = "Печать по XML шаблону";

    private Button CustomCommandBtn;
    private String pathCmd ="";
    private String pathSrc ="";
    private final int REQUEST_CMD=0;
    private final int REQUEST_SRC=1;
    private Button CustomCommandBtnStas;
    private Button doubleCheckStatusCommandBtn;

    Button xmlFile,cmdFile;
    EditText editPathCmd,editPathSrc;
    private String xmlFile2 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter name=\"testcmdtemplatefile\" type=\"template\">\n" +
            "\t\t\t<value type=\"path\" value=\"\"/>\n" +
            "\t\t\t<value name=\"V00\" type=\"variable\" value=\"Code=000001|UnitCode=796|Characteristic=Белый, 200 х 60 х 50|MDM_key=ca0fae48-92b1-406f-bfe2-90665c9808e5|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\"/>\n" +
            "\t\t\t<value name=\"V01\" type=\"variable\" value=\"Х-67890 Стинол Завод бытовой техники\"/>\n" +
            "\t\t\t<value name=\"V02\" type=\"variable\" value=\"000001\"/>\n" +
            "\t\t\t<value name=\"V03\" type=\"variable\" value=\"Белый, 200 х 60 х 50\"/>\n" +
            "\t\t\t<value name=\"V04\" type=\"variable\" value=\"шт (1 шт)\"/>\n" +
            "\t\t\t<value name=\"V05\" type=\"variable\" value=\"1234567\"/>\n" +
            "\t\t\t<value name=\"V06\" type=\"variable\" value=\"qwerty\"/>\n" +
            "\t\t\t<value name=\"V07\" type=\"variable\" value=\"cdr56yhn\"/>\n" +
            "\t\t\t<value name=\"V08\" type=\"variable\" value=\"5rtfgvhyu8ijk\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";
    private static final String DATA = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?><cmd name=\"print\"><parameters><parameter name=\"TMH_Label_58_40_my\" type=\"template\"><value name=\"QRCode\" type=\"variable\" value=\"{\"Номенклатура\":{\"КодАМТО\":\"000001\",\"ЕдиницаИзмеренияКод\":\"796 \",\"Характеристика\":\"\"},\"Серия\":{\"Наименование\":\"\",\"Номер\":\"\",\"ДатаПроизводства\":\"01.01.0001 0:00:00\",\"СрокГодности\":\"01.01.0001 0:00:00\"},\"Спецификация\":{\"Номер\":null,\"Дата\":\"\"},\"Грузоотправитель\":{\"ИНН\":\"\",\"КПП\":\"\"},\"Поставщик\":{\"ИНН\":\"\",\"КПП\":\"\"}}\"/><value name=\"Name\" type=\"variable\" value=\"Х-67890 Стинол Завод бытовой техники\"/></parameter><parameter name=\"\" type=\"quantity\"><value type=\"count\" value=\"1\" /></parameter></parameters></cmd>";
    private static final String DATA2 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter name=\"TMH_Label_58_40_my\" type=\"template\">\n" +
            "\t\t\t<value type=\"variable\" name=\"QRCode\" value=\"123456\"/>\n" +
            "\t\t\t<value name=\"Name\" type=\"variable\" value=\"Х-67890 Стинол Завод бытовой техники\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA3 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\n" +
            "\t\t<parameter name=\"mytemplate3params\" type=\"template\">\n" +
            "\t\t\t<value type=\"variable\" name=\"QRCode\" value=\"In another moment down went Alice after it, never once considering how in the world she was to get out again.\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Name\" value=\"Холодильник Стинол\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Manufacter\" value=\"НЛМК\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA4 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\n" +
            "\t\t<parameter name=\"mytemplate3params\" type=\"template\">\n" +
            "\t\t\t<value type=\"variable\" name=\"QRCode\" value=\"Code=000004|UnitCode=715|Characteristic=40, Коричневый, 6, натуральная кожа|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Name\" value=\"Холодильник Стинол\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Manufacter\" value=\"НЛМК\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA5 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\n" +
            "\t\t<parameter name=\"mytemplate3paramsv2\" type=\"template\">\n" +
            "\t\t\t<value type=\"variable\" name=\"QRCode\" value=\"Code=000004|UnitCode=715|Characteristic=40, Коричневый, 6, натуральная кожа|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Name\" value=\"Холодильник Стинол\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Manufacter\" value=\"НЛМК\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA6 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\n" +
            "\t\t<parameter name=\"TMH_Label_58_40\" type=\"template\">\n" +
            "\t\t\t<value type=\"variable\" name=\"QRCode\" value=\"Code=000004|UnitCode=715|Characteristic=40, Коричневый, 6, натуральная кожа|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Name\" value=\"Х-67890 Стинол Завод бытовой техники\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Code\" value=\"это поле для кода\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"SerName\" value=\"Какое-то SerName\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"ExpDate\" value=\"ну допустим до 2077 г.\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Characteristic\" value=\"Характер нордический, стойкий\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Supplier\" value=\"Липецк\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Shipper\" value=\"Дальнобой\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"MeasureUnit\" value=\"тонны чугуния\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA7 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"template\" name=\"mytemplate3paramsv2\">\n" +
            "\t\t\t<value type=\"variable\" name=\"QRCode\" value=\"qweqweqweqwe123123123qweqweqwe\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Name\" value=\"Холодильник Стинол\"/>\n" +
            "\t\t\t<value type=\"variable\" name=\"Manufacter\" value=\"НЛМК\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";



    private static final String DATA_CUSTOM_COMMAND_ONE_LINE3 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"print\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter name=\"mytemplate3paramsv2\" type=\"template\"" +
            "<value type=\"variable\" name=\"QRCode\" value=\"qweqweqweqwe123123123qweqweqwe\" />\n" +
            "<value type=\"variable\" name=\"Name\" value=\"Холодильник Стинол\" />\n" +
            "<value type=\"variable\" name=\"Manufacter\" value=\"НЛМК\" />\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";





    private static final String DATA_CUSTOM_COMMAND = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"cmd\">\n" +
            "\t\t\t<value type=\"data\" value=\"^Q40,3\n" +
            "^W58\n" +
            "^H8\n" +
            "^P1\n" +
            "^S2\n" +
            "^AD\n" +
            "^C1\n" +
            "^R0\n" +
            "~Q+0\n" +
            "^O0\n" +
            "^D0\n" +
            "^E0\n" +
            "~R255\n" +
            "^L\n" +
            "Dy2-me-dd\n" +
            "Th:m:s\n" +
            "AD,45,29,1,1,0,0E,Тествая надпись\n" +
            "E\n" +
            "\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA_CUSTOM_COMMAND_STAS = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"cmd\">\n" +
            "\t\t\t<value type=\"data\" value=\"^Q40,3\n" +
            "^W58\n" +
            "^H12\n" +
            "^P1\n" +
            "^S2\n" +
            "^AD\n" +
            "^C1\r\n" +
            "^R0\n" +
            "~Q+0\n" +
            "^O0\n" +
            "^D0\n" +
            "^E0\n" +
            "~R255\n" +
            "^L\n" +
            "Dy2-me-dd\n" +
            "Th:m:s\n" +
            "Dy2-me-dd\n" +
            "Th:m:s\n" +
            "AD,329,16,1,1,0,0E,Привет\n" +
            "AD,331,76,1,1,0,0E,Мир\n" +
            "E\n" +
            "\"/>\n" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";


    private static final String DATA_CUSTOM_COMMAND_ONE_LINE = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"cmd\">\n" +
            "\t\t\t<value type=\"data\" value=\"^Q40,3&#xD;&#xA;^W58&#xD;&#xA;^H12&#xD;&#xA;^P1&#xD;&#xA;^S2&#xD;&#xA;^AD&#xD;&#xA;^C1&#xD;&#xA;^R0&#xD;&#xA;~Q+0&#xD;&#xA;^O0&#xD;&#xA;^D0&#xD;&#xA;^E0&#xD;&#xA;~R255&#xD;&#xA;^L&#xD;&#xA;Dy2-me-dd&#xD;&#xA;Th:m:s&#xD;&#xA;Dy2-me-dd&#xD;&#xA;Th:m:s&#xD;&#xA;AD,329,16,1,1,0,0E,Привет&#xD;&#xA;AD,331,76,1,1,0,0E,Мир&#xD;&#xA;E&#xD;&#xA;" + "\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";


    private static final String DATA_CUSTOM_COMMAND_ONE_LINE2 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "                <parameters>\n" +
            "                               <parameter type=\"cmd\">\n" +
            "                                               <value type=\"data\" value=\"^XSETCUT,DOUBLECUT,0&#xD;&#xA;^Q60,3&#xD;&#xA;^W100&#xD;&#xA;^H15&#xD;&#xA;^P1&#xD;&#xA;^S4&#xD;&#xA;^AD&#xD;&#xA;^C1&#xD;&#xA;^R0&#xD;&#xA;~Q+0&#xD;&#xA;^O0&#xD;&#xA;^D0&#xD;&#xA;^E0&#xD;&#xA;~R255&#xD;&#xA;^L&#xD;&#xA;Dy2-me-dd&#xD;&#xA;Th:m:s&#xD;&#xA;V00,500,QRCode,jc50&#xD;&#xA;V01,60,Name1,jl8&#xD;&#xA;V02,60,Name2,jl8&#xD;&#xA;V03,60,Name3,jl8&#xD;&#xA;V04,15,Code,jl8&#xD;&#xA;V05,50,MeasureUnit,jl8&#xD;&#xA;V06,50,SerName,jl8&#xD;&#xA;V07,50,ExpDate,jl8&#xD;&#xA;V08,100,Characteristic,jl8&#xD;&#xA;V09,100,Shipper,jl8&#xD;&#xA;V10,100,Supplier,jl8                &#xD;&#xA;W850,218,5,1,M0,8,4,265,0&#xD;&#xA;Code=000001|UnitCode=796|Characteristic=Белый, 200 х 60 х 50|MDM_key=ca0fae48-92b1-406f-bfe2-90665c9808e5|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|&#xD;&#xA;R10,230,849,529,2,2&#xD;&#xA;Lo,10,289,849,290&#xD;&#xA;Lo,10,349,849,350&#xD;&#xA;Lo,10,409,849,410&#xD;&#xA;Lo,10,469,849,470&#xD;&#xA;Lo,297,230,298,529&#xD;&#xA;&#xD;&#xA;R10,528,1190,707,2,2&#xD;&#xA;Lo,10,587,1190,588&#xD;&#xA;Lo,10,647,1190,648&#xD;&#xA;Lo,297,528,298,707&#xD;&#xA;&#xD;&#xA;Lo,10,12,11,229&#xD;&#xA;Lo,1189,10,1190,531&#xD;&#xA;Lo,10,10,1190,11&#xD;&#xA;AD,17,241,1,1,0,0E,Код АМТО&#xD;&#xA;AD,17,302,1,1,0,0E,Ед. изм.&#xD;&#xA;AD,17,359,1,1,0,0E,Серия&#xD;&#xA;AD,17,421,1,1,0,0E,Поступление&#xD;&#xA;AD,17,478,1,1,0,0E,Годен до&#xD;&#xA;AD,17,541,1,1,0,0E,Характеристика&#xD;&#xA;AD,17,598,1,1,0,0E,Грузоотправитель&#xD;&#xA;AD,17,657,1,1,0,0E,Поставщик&#xD;&#xA;AD,27,30,1,1,0,0E,Х-67890 Стинол Завод бытовой техники&#xD;&#xA;AD,27,90,1,1,0,0E,Х-67890 Стинол Завод бытовой техники&#xD;&#xA;AD,27,150,1,1,0,0E,Х-67890 Стинол Завод бытовой техники                &#xD;&#xA;AD,302,241,1,1,0,0E,000001&#xD;&#xA;AD,302,302,1,1,0,0E,шт (1 шт)&#xD;&#xA;AD,302,359,1,1,0,0E,&#xD;&#xA;AD,302,478,1,1,0,0E,&#xD;&#xA;AD,302,541,1,1,0,0E,Белый, 200 х 60 х 50&#xD;&#xA;AD,302,598,1,1,0,0E,&#xD;&#xA;AD,302,657,1,1,0,0E,&#xD;&#xA;E\" />\n" +
            "                               </parameter>\n" +
            "                </parameters>\n" +
            "</cmd>";

    private static final String DATA_DOUBLE_CHECK = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"cmd\">\n" +
            "\t\t\t<value type=\"data\" value=\"~S\n" +
            "\t\t\t~S\" />\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA_DOUBLE_CHECK2 = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"cmd\">\n" +
            "\t\t\t<value type=\"data\" value=\"^XSET,IMMEDIATE,1\" />\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";

    private static final String DATA_DOUBLE_CHECK2_CR = "<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>\n" +
            "<cmd name=\"custom_command\">\n" +
            "\t<parameters>\n" +
            "\t\t<parameter type=\"cmd\">\n" +
            "\t\t\t<value type=\"data\" value=\"^XSETCUT,DOUBLECUT,0\r" +
            "^Q60,3\r" +
            "^W100\r" +
            "^H15\r" +
            "^P1\r" +
            "^S4\r" +
            "^AD\r" +
            "^C1\r" +
            "^R0\r" +
            "~Q+0\r" +
            "^O0\r" +
            "^D0\r" +
            "^E0\r" +
            "~R255\r" +
            "^L\r" +
            "Dy2-me-dd\r" +
            "Th:m:s\r" +
            "V00,500,QRCode,jc50\r" +
            "V01,500,Name,jl50\r" +
            "V02,15,Code,jl8\r" +
            "V03,50,SerName,jl8\r" +
            "V04,50,ExpDate,jl8\r" +
            "V05,150,Characteristic,jl8\r" +
            "V06,150,Supplier,jl8\r" +
            "V07,150,Shipper,jl8\r" +
            "V08,50,MeasureUnit,jl8\r" +
            "W846,214,5,2,M0,8,5,4,0\r" +
            "Code=000004|UnitCode=715|Characteristic=40, Коричневый, 6, натуральная кожа|SerName=|SerNumber=|ProdDate=01.01.0001 0:00:00|ExpDate=01.01.0001 0:00:00|DocNo=|DocDate=01.01.0001 0:00:00|SupplierINN=|SupplierKPP=|ShipperINN=|ShipperKPP=|\r" +
            "R0,241,839,540,2,2\r" +
            "Lo,0,300,839,301\r" +
            "Lo,0,360,839,361\r" +
            "Lo,0,420,839,421\r" +
            "Lo,0,480,839,481\r" +
            "Lo,287,241,288,540\r" +
            "R0,539,1196,718,2,2\r" +
            "Lo,0,598,1196,599\r" +
            "Lo,0,658,1196,659\r" +
            "Lo,287,539,288,718\r" +
            "Lo,0,0,1,239\r" +
            "Lo,1195,0,1196,539\r" +
            "Lo,0,0,1199,1\r" +
            "AD,9,247,1,1,0,0E,Код АМТО\r" +
            "AD,9,313,1,1,0,0E,Ед. изм.\r" +
            "AD,9,370,1,1,0,0E,Серия\r" +
            "AD,9,432,1,1,0,0E,Поступление\r" +
            "AD,9,489,1,1,0,0E,Годен до\r" +
            "AD,9,552,1,1,0,0E,Характеристика\r" +
            "AD,9,610,1,1,0,0E,Грузоотправитель\r" +
            "AD,9,670,1,1,0,0E,Поставщик\r" +
            "AD,28,19,1,1,0,0E,Мужские мокасины\r" +
            "AD,303,254,1,1,0,0E,000004\r" +
            "AD,306,313,1,1,0,0E,пара (1 пара)\r" +
            "AD,304,371,1,1,0,0E,\r" +
            "AD,302,491,1,1,0,0E,\r" +
            "AD,304,552,1,1,0,0E,40, Коричневый, 6, натуральная кожа\r" +
            "AD,302,609,1,1,0,0E,\r" +
            "AD,301,669,1,1,0,0E,\r" +
            "E\"/>\r" +
            "\t\t</parameter>\n" +
            "\t\t<parameter name=\"\" type=\"quantity\">\n" +
            "\t\t\t<value type=\"count\" value=\"1\"/>\n" +
            "\t\t</parameter>\n" +
            "\t</parameters>\n" +
            "</cmd>";



    private View.OnClickListener clickListener= new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Intent intent = new Intent(getContext(), utils.dialogDirPicker.class);
            intent.addCategory(Intent.CATEGORY_DEFAULT);
            intent.putExtra(dialogDirPicker.EXTRA_FILTER, ".txt;.xls;.xml;.db");
            intent.putExtra(dialogDirPicker.EXTRA_BEGIN_DIR, editPathCmd.getText().toString());
            startActivityForResult(intent, REQUEST_SRC);

        }
    };



    @SuppressLint({"MissingInflatedId", "NewApi"})
    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.xml_layout, container, false);
        PrintAdapter pa = PrintAdapter.getInstance(getActivity());
        CustomCommandBtn = view.findViewById(R.id.printCustomCommandBtn);
        xmlFile = view.findViewById(R.id.buttonEnterFileXmlCustom);
        editPathCmd = view.findViewById(R.id.editTextXmlCustom);

        xmlFile.setOnClickListener(clickListener);
        CustomCommandBtn.setOnClickListener(view1 -> {
            readFile(pa);
        });

        return view;
    }


    /*
    * Чтение содержимого файла по его пути
    * */
    private void readFile(PrintAdapter pa){

        String filePath = editPathCmd.getText().toString();

        StringBuilder content = new StringBuilder();

        try (BufferedReader br = new BufferedReader(new FileReader(filePath))) {
            String line;
            while ((line = br.readLine()) != null) {
                content.append(line).append("\n");
            }
            pa.sendServiceCmd(content.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


    @Override
    public String getPrintData() {
        return "";
    }

    @Override
    public SparseArray<variable> getVariables() {
        variables.clear();
        return variables;
    }

    @Override
    public void PromptVariables(SparseArray<variable> vars) {
        pathCmd=editPathCmd.getText().toString();
        packer =InitPrintData(pathCmd);

        Bundle args= new Bundle();
        args.putSparseParcelableArray(EXTRA_VARIABLE, vars);

        dlg = new VariablePromptDialog();
        dlg.setArguments(args);
        dlg.setTargetFragment(this, REQUEST_ANSWER_CODE);
        dlg.show(m_parentActivity.getSupportFragmentManager(), "");
        bPromptDialogIsShown=true;
    }


    @Override
    public void OnDialogResult(@NonNull SparseArray<variable> result) {
        param.clear();
        pathCmd=editPathCmd.getText().toString();
        param.addValue(DataPacker.values.VAL_PATH, null, pathCmd);

//        Iterator<String> it=result.keySet().iterator();
//        int i=0;
//        while(it.hasNext()){
//            String key=it.next();
//            String value=result.get(key).value;
//            String varName="V" + i;
//            param.addValue(data_packer.values.VAL_VARIABLE, varName, value);
//            i++;
//        }

        for(int i=0; i<result.size(); i++){
            variable v=result.get(i);
            String varName="V" + i;
            param.addValue(DataPacker.values.VAL_VARIABLE, varName, v.value);
        }
        PrintAdapter.getInstance(m_parentActivity).sendServiceCmd(packer.toString());
    }

    @Override
    public void OnDissmissDalog() {
        bPromptDialogIsShown=false;

    }


    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(resultCode== Activity.RESULT_OK) {
            pathCmd = data.getStringExtra(utils.dialogDirPicker.EXTRA_RESULT);
            editPathCmd.setText(pathCmd);
        }
    }


    private DataPacker InitPrintData(String template){
        //Начальная инициализация пакета с данными для посылки в service
        DataPacker packer = new DataPacker();
        try {
            packer.setCommand(DataPacker.commands.CMD_PRINT);
            packer.addParam(DataPacker.parameters.PARAM_QUANTITY, DataPacker.values.VAL_COUNT, "", m_quantity);
            param = packer.addParam(DataPacker.parameters.PARAM_CMD_FILE, template);
        }
        catch(Exception e){
            utils.logger.get().write(e.toString() + " " + e.getMessage());
        }
        return packer;
    }



    private static List<String> extractValues(Document doc) {
        List<String> values = new ArrayList<>();
        NodeList valueNodes = doc.getElementsByTagName("value");

        for (int i = 0; i < valueNodes.getLength(); i++) {
            Node node = valueNodes.item(i);
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                Element element = (Element) node;
                String value = element.getAttribute("value");
                if (!value.isEmpty()) {
                    values.add(value);
                }
            }
        }
        return values;
    }

    private static void writeResultsToFile(File outputFile, List<String> values) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile))) {
            writer.write(String.join(",", values));
        }
    }


    private void dismissDlg(){
        if(dlg!=null){
            dlg.dismissAllowingStateLoss();
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        dismissDlg();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        dismissDlg();
    }
}
