package utils;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PermissionInfo;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;

import com.google.android.material.snackbar.Snackbar;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import ru.scancode.GodexPrintTest.R;

//Простой диалог выбора файла
public class dialogDirPicker extends Activity {
    ListView list_dir;
    TextView textPath;
    Context _context;
    int select_id_list = -1;
    String path = "/";
    ArrayList<String> ArrayDir = new ArrayList<>();
    private ItemsAdapter adapter;
    private boolean bDirsOnly=true;
    private String[] strFilter;
    private Activity m_activity;
    private String[] permissions = new String[]{Manifest.permission.READ_EXTERNAL_STORAGE};
    private final int REQUEST_CODE_PERMISSION=0;
    public static final String EXTRA_DIRS_ONLY="only_directories";
    public static final String EXTRA_BEGIN_DIR="";
    public static final String EXTRA_RESULT="url";
    public static final String EXTRA_FILTER="filter";

    protected void onCreate(Bundle savedInstanceState) {
        _context = this;
        m_activity=this;
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dialog_dir_picker);
        Intent intent=getIntent();

        if(intent!=null) {
            bDirsOnly = intent.getBooleanExtra(EXTRA_DIRS_ONLY, true);
            path = intent.getStringExtra(EXTRA_BEGIN_DIR);
            String tmpFilter=intent.getStringExtra(EXTRA_FILTER);

            if(tmpFilter!=null) {
                if(tmpFilter.contains(";")) {
                    strFilter = tmpFilter.split(";");
                }
                else{
                    strFilter=new String[]{tmpFilter};
                }
            }

        }
        if(path==null || path.isEmpty())
            path= Environment.getExternalStorageDirectory().getPath() + "/";

        if(strFilter==null){
            strFilter=new String[]{};
        }

        list_dir = (ListView) findViewById(R.id.list_dir);
        textPath = (TextView) findViewById(R.id.textPath);

        adapter = new ItemsAdapter(this, android.R.layout.simple_list_item_1, ArrayDir); //new ArrayAdapter<>(this, android.R.layout.simple_list_item_1, ArrayDir);
        list_dir.setAdapter(adapter);


        update_list_dir();

        list_dir.setOnItemClickListener(new OnItemClickListener() {
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                select_id_list = (int) id;
                String strPath=path + adapter.getItem(select_id_list);
                File file= new File(strPath);
                if(file.isFile()){
                    path=strPath;
                    onClickGo(null);
                }
                else
                {
                    update_list_dir();
                }
            }
        });

    }

    private void requestPerms(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M){
            if(this.checkSelfPermission(permissions[0])!= PackageManager.PERMISSION_GRANTED){
                PackageManager pm =getPackageManager();
                try {
                    PermissionInfo pInfo=pm.getPermissionInfo(permissions[0], PackageManager.GET_META_DATA);
                    if(pInfo!=null && pInfo.protectionLevel== PermissionInfo.PROTECTION_DANGEROUS) {
                        ActivityCompat.requestPermissions(this, permissions, REQUEST_CODE_PERMISSION);
                    }
                } catch (PackageManager.NameNotFoundException e) {
                    Snackbar.make(list_dir, e.getMessage(), Snackbar.LENGTH_LONG).show();
                }
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if(grantResults.length==permissions.length) {
            String log = getString(R.string.denied);
            if (grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                log = getString(R.string.granted);
                update_list_dir();
            }
            logger.get().write(permissions[0] + " " + log);
            Snackbar.make(list_dir, permissions[0] + " " + log, Snackbar.LENGTH_LONG).show();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        new Timer().schedule(new TimerTask() {
            @Override
            public void run() {
                if (ActivityCompat.shouldShowRequestPermissionRationale(m_activity,
                        Manifest.permission.READ_EXTERNAL_STORAGE)) {
                    Snackbar.make(list_dir, R.string.permission_rationale, Snackbar.LENGTH_LONG)
                            .setAction(R.string.grant, new View.OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    requestPerms();
                                }
                            })
                            .show();
                } else {
                    requestPerms();
                }
            }
        }, 500);
    }

    public void onCancelClick(View view){
        Intent intent = new Intent();
        intent.putExtra(EXTRA_RESULT, "");

        setResult(Activity.RESULT_CANCELED, intent);
        finish();
    }

    public void onClickBack(View view) {
        path = new File((path==null ? "/" : path)).getParent();
        if(path==null){
            path="/";
        }
        else if (!path.endsWith("/")){
            path +="/";
        }
        update_list_dir();
    }

    public void onClickGo(View view) {
        Intent intent = new Intent();
        intent.putExtra(EXTRA_RESULT, path);

        setResult(Activity.RESULT_OK, intent);
        finish();
    }

    private void update_list_dir() {
        if (select_id_list != -1)
            path = path + adapter.getItem(select_id_list) + "/";

        select_id_list = -1;
        adapter.clear();
        String fileName="";

        File pfile=new File(path);
        if(pfile.isFile()){
            path=pfile.getParent() + "/";
            fileName=pfile.getName();
        }

        File[] files = new File(path).listFiles();
        if(files!=null) {
            Arrays.sort(files, new Comparator<File>() {
                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });

            List<File> dirs= new ArrayList<>();
            List<File> files_= new ArrayList<>();
            List<File> all = new ArrayList<>();

            for(File file: files){
                if(file.isDirectory()){
                    dirs.add(file);
                }
                else{
                    files_.add(file);
                }
            }

            all.addAll(dirs);
            all.addAll(files_);

            for (File aFile : all) {
                if (aFile.isDirectory() && bDirsOnly) {
                    if (dir_opened(aFile.getPath())) {
                        adapter.add(aFile.getName());
                    }
                } else {
                    String file=aFile.getName();
                    if(compareFilter(file)) {
                        adapter.add(file);
                    }
                    if(fileName.equals(file)){
                        select_id_list=adapter.getCount()-1;
                    }
                }
            }
            adapter.notifyDataSetChanged();
            list_dir.setSelection(select_id_list);
            textPath.setText(path);
        }
    }

    private boolean compareFilter(String fileName) {
        boolean bResult = false;
        if (strFilter != null && strFilter.length > 0) {
            for (String f : strFilter) {
                if (fileName.toLowerCase().endsWith(f)) {
                    bResult = true;
                    break;
                }
            }
        } else {
            bResult = true;
        }
        return bResult;
    }

    private boolean dir_opened(String url) {
        try {
            File[] files = new File(url).listFiles();
            for (@SuppressWarnings("unused") File aFile : files) {
            }
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    class ItemsAdapter extends ArrayAdapter<String> {
        private Context m_context;
        private LayoutInflater inflater;
        private int nRes;
        private ArrayList<String> items = new ArrayList<>();

        public ItemsAdapter(@NonNull Context context, int resource, @NonNull ArrayList<String> objects) {
            super(context, resource, objects);

            this.inflater = LayoutInflater.from(context);
            this.m_context = context;
            this.nRes = resource;
            items = objects;
        }

        @Override
        public void add(@Nullable String object) {
            //super.add(object);
            items.add(object);
        }

        @Nullable
        @Override
        public String getItem(int position) {
            //return super.getItem(position);
            return items.get(position);
        }

        @NonNull
        @Override
        public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            View result = inflater.inflate(nRes, parent, false);
            TextView txt = result.findViewById(android.R.id.text1);
            String fileName = getItem(position);
            if (txt != null && fileName != null) {
                txt.setText(fileName);
                File file = new File(path + fileName);
                if (file.isFile() && strFilter != null && strFilter.length > 0) {
                    txt.setTextColor(Color.GREEN);
                }
            }
            return result;
        }
    }

}
