package utils;

import android.os.Environment;
import android.util.Log;

import androidx.annotation.Nullable;

import com.sun.mail.util.logging.CompactFormatter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.ErrorManager;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;


public class logger {
    private static final String TAG = "PrintTest.LOGS";
    private FileHandler fh;
    private static Level _level = Level.ALL;
    private static final long MAX_FILE_SIZE = 2048000L;//~2Mb
    private CompactFormatter _formatter = new CompactFormatter("[%1$tc] %2$s - %5$s%n");
    private final int stack_depth = 5;
    private Logger _logger;
    private static logger _instance = null;
    private myErrorManager errorManager = new myErrorManager();
    private int nCountTriesToRecreate = 0;
    private String SETTINGS_ERROR_LOG_PATH = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS) + "/PrintTest.log";

    private final int ERR_FILE_NOT_FOUND = 1;

    public static logger get() {
        if (_instance == null) {
            _instance = new logger(TAG);
        }
        _instance.initFileHandler();
        return _instance;
    }

    private class myErrorManager extends ErrorManager {
        @Override
        public synchronized void error(String msg, Exception ex, int code) {
            super.error(msg, ex, code);
            Log.e(TAG, msg, ex);

            switch (code) {
                case ERR_FILE_NOT_FOUND:
                    Log.i(TAG, "try recreate log file");
                    fh.close();
                    _logger.removeHandler(fh);
                    fh = getFileHandler(SETTINGS_ERROR_LOG_PATH);
                    if (fh != null && nCountTriesToRecreate < 1) {
                        nCountTriesToRecreate++;
                        Log.i(TAG, "created new log file");
                        _logger.addHandler(fh);
                        LogRecord rec = new LogRecord(_level, msg);
                        fh.publish(rec);
                        fh.flush();
                        nCountTriesToRecreate = 0;
                    } else {
                        Log.i(TAG, "could not create log file");
                    }
                    break;
            }
        }
    }

    private class myFileHandler extends FileHandler {
        private String file;

        myFileHandler(String pattern, boolean append) throws IOException, SecurityException {
            super(pattern, append);
            file = pattern;
        }

        @Override
        public synchronized void publish(LogRecord record) {
            if (!new File(file).exists()) {
                reportError(record.getMessage(), new IOException("file " + file + " not found"), ERR_FILE_NOT_FOUND);
            }
            super.publish(record);
        }
    }

    @Nullable
    private FileHandler getFileHandler(String fileName) {
        FileHandler h = null;
        try {
            h = new myFileHandler(fileName, true);
            h.setErrorManager(errorManager);
            h.setFormatter(_formatter);
        } catch (IOException e) {
            e.printStackTrace();
            Log.e(TAG, e.getMessage() != null ? e.getMessage() : e.toString());
        }
        return h;
    }

    private ConsoleHandler initConsoleHandler() {
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(_level);
        h.setFormatter(_formatter);
        return h;
    }

//    ProgramSettingsData.IOnChangedCallback _callback = () -> {
//        String fileName = ProgramSettingsData.SETTINGS_FILE_LOG_PATH;
//        if (ProgramSettingsData.SETTINGS_WRITE_FILE_LOG) {
//            //max 5Mb single log file size
//            //log files count max 100
//            if (fh == null) {
//                fh = initFileHandler(fileName);
//                if (fh != null) {
//                    _logger.addHandler(fh);
//                }
//            }
//        }
//    };

    protected logger(String name) {
        _logger = Logger.getLogger(name);
//        initFileHandler();
    }

    private StackTraceElement getStackEl() {
        StackTraceElement result = null;
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();

        for (int i = 0; i < stack.length; i++) {
            StackTraceElement el = stack[i];
            if (el.getClassName().equals(getClass().getName())) {
                result = stack[i + 2];
                break;
            }
        }

        if (result == null) {
            int nDeepIndex = stack_depth;
            while (nDeepIndex > stack.length - 1) {
                nDeepIndex--;
            }
            result = stack[nDeepIndex];
        }
        return result;
    }

    public void write(@Nullable String msg) {
        StackTraceElement el = getStackEl();
        String message = getCurrentClassName(el) + "." + getCurrentMethodName(el) + "(" + getLineNumber(el) + ")";
        message += ": " + (msg == null ? "" : msg.replace("\n", " "));
        _logger.info(message);
    }

    public void write(@Nullable String msg, boolean useLineSeparator) {
        if (!useLineSeparator) {
            write(msg);
        } else {
            StackTraceElement el = getStackEl();
            String message = getCurrentClassName(el) + "." + getCurrentMethodName(el) + "(" + getLineNumber(el) + ")";
            message += ": " + (msg == null ? "" : msg);
            _logger.info(message);
        }
    }

    //Добавить инфолог в файл без сообщения
    public void write() {
        StackTraceElement el = getStackEl();
        String message = getCurrentClassName(el) + "." + getCurrentMethodName(el) + "(" + getLineNumber(el) + ")";
        _logger.info(message);
    }

    public void error(String msg) {
        StackTraceElement el = getStackEl();
        String message = getCurrentClassName(el) + "." + getCurrentMethodName(el);
        message += "(:" + getLineNumber(el) + ")" + ": " + msg;
        _logger.severe(message);
    }

    public void exception(String msg) {
        _logger.severe(msg);
    }

    public void error(Throwable throwable) {
        String message = "CATCHED EXCEPTION: "
                + throwable.toString()
                + System.lineSeparator()
                + String.format("%49s %s", "", "TRACE: ")
                + throwable.getStackTrace()[0].toString();

        _logger.severe(message);
        throwable.printStackTrace();
        writeErrorLog(throwable);
    }

    public void writeErrorLog(Throwable throwable) {
        writeErrorLog(throwable, "EXCEPTION TRACE");
    }

    public void writeErrorLog(Throwable throwable, String header) {

        try {
            File file = new File(SETTINGS_ERROR_LOG_PATH);
            if (!file.createNewFile()) {
                if (file.length() > MAX_FILE_SIZE) {
                    file.delete();
                    file.createNewFile();
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy", Locale.getDefault());
            String date = dateFormat.format(new Date());
            String format = "%" + (date.length() + 2) + "s %s";

            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder
                    .append(String.format("[%s]", date))
                    .append(String.format(" %s: ", header))
                    .append(throwable.toString())
                    .append(System.lineSeparator());

            StackTraceElement[] stackTraceElements;
            Throwable cause = throwable.getCause();

            // Если есть причина - выводим ее, если нет - стектрейс
            if (cause != null) {
                stackTraceElements = throwable.getCause().getStackTrace();
                stringBuilder.append(String.format(format, "", "CAUSED BY: ")).append(System.lineSeparator());
            } else {
                stackTraceElements = throwable.getStackTrace();
            }

            for (StackTraceElement ste : stackTraceElements) {
                stringBuilder.append(String.format(format, "", ste.toString())).append(System.lineSeparator());
            }

            //Запись в файл ошибок
            fileOutputStream.write(stringBuilder.toString().getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();

        } catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }

    }

    private void setFormatter(Formatter formatter) {
        for (Handler h : _logger.getHandlers()) {
            h.setFormatter(formatter);
        }
    }

    private String[] getAllName() {
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        int nDeepIndex = stack_depth;
        if (ste.length - 1 >= nDeepIndex) {
            nDeepIndex = ste.length - 1;
        }
        return new String[]{
                ste[nDeepIndex].getFileName(),
                ste[nDeepIndex].getMethodName(),
                ste[nDeepIndex].getClassName(),
                String.valueOf(ste[nDeepIndex].getLineNumber())
        };
    }

    private String getCurrentClassName(StackTraceElement stack) {
        String result = stack.getClassName();
        if (result.contains(".")) {
            result = result.substring(result.lastIndexOf(".") + 1);
        }
        return result;
    }

    private String getCurrentMethodName(StackTraceElement stack) {
        return stack.getMethodName();
    }

    private String getLineNumber(StackTraceElement stack) {
        return String.valueOf(stack.getLineNumber());
    }

    @Deprecated
    private String getCurrentClassName() {
        String[] array = getAllName();
        String result = array[2];
        if (array[2].contains(".")) {
            result = array[2].substring(array[2].lastIndexOf(".") + 1);
        }
        return result;
    }

    @Deprecated
    private String getCurrentMethodName() {
        String[] array = getAllName();
        return array[1];
    }

    @Deprecated
    private String getLineNumber() {
        String[] array = getAllName();
        return array[3];
    }

    private void initFileHandler() {
        if (_logger.getHandlers().length == 0) {
            FileHandler fh = getFileHandler(SETTINGS_ERROR_LOG_PATH);
            if(fh != null) {
                _logger.addHandler(fh);
            }
        }
    }
}
